/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm;

import com.juraszek.algorithm.heuristics.CalculationMethod;
import com.juraszek.algorithm.heuristics.MissingDataService;
import com.juraszek.algorithm.heuristics.ReciprocalMatrixConverter;
import com.juraszek.algorithm.heuristics.jacobi.JacobiAlgorithm;
import com.juraszek.algorithm.models.HREModel;
import com.juraszek.algorithm.models.Pair;
import com.juraszek.algorithm.utils.HREResultConverter;
import com.juraszek.algorithm.utils.xmcda.Parameters;
import com.juraszek.algorithm.utils.xmcda.XMCDAProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HREAlgorithm {
    @Autowired
    private MissingDataService missingDataService;
    @Autowired
    private ReciprocalMatrixConverter reciprocalMatrixConverter;
    @Autowired
    private XMCDAProperties xmcdaProperties;
    @Autowired
    private JacobiAlgorithm jacobiAlgorithm;
    @Autowired
    private HREResultConverter hreResultConverter;

    public HREModel singleCalculate(HREModel inputs) throws Exception {
        Double[][] pairsComparisons = inputs.getPairsComparisons();
        Double[] alternativesWeights = inputs.getAlternativesWeights();
        List<Pair> missingPairList = this.missingDataService.findMissingData(pairsComparisons = this.missingDataService.calculateMissingDataIfOccurs(pairsComparisons));
        if (!missingPairList.isEmpty()) {
            pairsComparisons = this.missingDataService.tryToProposeMissingData(pairsComparisons, alternativesWeights, missingPairList);
        }
        if (((Boolean)this.xmcdaProperties.getParameter(Parameters.TryToReciprocalMatrix)).booleanValue()) {
            pairsComparisons = this.reciprocalMatrixConverter.convertToReciprocalMatrix(pairsComparisons);
        }
        Double[] jacobiResult = this.jacobiAlgorithm.solve(pairsComparisons, alternativesWeights, missingPairList);
        if (CalculationMethod.Geometric.name().equals(this.xmcdaProperties.getParameter(Parameters.CalculationMethod))) {
            jacobiResult = this.hreResultConverter.rescaleResult(jacobiResult);
        }
        Double[] results = this.hreResultConverter.convertToResult(alternativesWeights, jacobiResult);
        if (((Boolean)this.xmcdaProperties.getParameter(Parameters.NormalizeResults)).booleanValue()) {
            results = this.hreResultConverter.normalizeResult(results);
        }
        inputs.setAlternativesWeights(results);
        return inputs;
    }
}

