/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm;

import com.juraszek.algorithm.HREAlgorithm;
import com.juraszek.algorithm.io.IOService;
import com.juraszek.algorithm.io.ProgramExecutionResultsService;
import com.juraszek.algorithm.models.HREModel;
import com.juraszek.algorithm.utils.xmcda.CmdLineParser;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import com.juraszek.algorithm.utils.xmcda.XMCDAProperties;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xmcda.ProgramExecutionResult;

@Service
public class HRERunner {
    @Autowired
    private HREAlgorithm hreAlgorithm;
    @Autowired
    private IOService ioService;
    @Autowired
    private XMCDAProperties xmcdaProperties;
    @Autowired
    private CmdLineParser cmdLineParser;
    @Autowired
    private ProgramExecutionResultsService programExecutionResultsService;

    public void start(String[] args) throws Throwable {
        CmdLineParser.Arguments params = this.cmdLineParser.parseCmdLineArguments(args);
        File prgExecResults = new File(params.outputDirectory, "messages.xml");
        ProgramExecutionResult executionResult = new ProgramExecutionResult();
        this.xmcdaProperties.initXMCDAVersion(executionResult, prgExecResults, params.xmcdaVersion);
        HREModel inputs = this.ioService.readInputs(params, executionResult, prgExecResults);
        this.xmcdaProperties.initHeuristicMethod(executionResult, prgExecResults, params.xmcdaVersion);
        try {
            inputs = this.hreAlgorithm.singleCalculate(inputs);
        }
        catch (Throwable t) {
            String message = XMCDAMessageParser.getMessage("The calculation could not be performed, reason: ", t);
            executionResult.addError(message);
            this.programExecutionResultsService.writeProgramExecutionResultsAndExit(prgExecResults, executionResult, message, params.xmcdaVersion);
        }
        this.ioService.writeOutput(params, inputs, executionResult, prgExecResults);
    }
}

