/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.heuristics.jacobi;

import com.juraszek.algorithm.heuristics.MissingDataService;
import com.juraszek.algorithm.heuristics.jacobi.JacobiParametersCreator;
import com.juraszek.algorithm.heuristics.methods.HeuristicMethodManager;
import com.juraszek.algorithm.models.Pair;
import com.juraszek.algorithm.utils.HREResultConverter;
import com.juraszek.algorithm.utils.xmcda.Parameters;
import com.juraszek.algorithm.utils.xmcda.XMCDAProperties;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JacobiAlgorithm {
    @Autowired
    private XMCDAProperties xmcdaProperties;
    @Autowired
    private JacobiParametersCreator jacobiParametersCreator;
    @Autowired
    private HREResultConverter hreResultConverter;
    @Autowired
    private MissingDataService missingDataService;
    @Autowired
    private HeuristicMethodManager heuristicMethodManager;

    /*
     * Unable to fully structure code
     */
    public Double[] solve(Double[][] pairsComparisons, Double[] alternativesWeights, List<Pair> missingPairList) {
        constants = this.jacobiParametersCreator.generateVectorOfConstants(pairsComparisons, alternativesWeights);
        factors = this.jacobiParametersCreator.generateMatrixOfFactors(pairsComparisons, alternativesWeights);
        inputMatrix = this.prepareInputMatrix(factors, constants);
        iterations = 0;
        inputSize = inputMatrix.length;
        epsilon = 1.0E-15;
        currentIterationResult = new Double[inputSize];
        previousIterationResult = new Double[inputSize];
        resultWithLowestError = new Double[inputSize];
        smallestError = null;
        Arrays.fill(currentIterationResult, (Object)0.0);
        Arrays.fill(previousIterationResult, (Object)0.0);
        while (true) {
            for (i = 0; i < inputSize; ++i) {
                sum = inputMatrix[i][inputSize];
                for (j = 0; j < inputSize; ++j) {
                    if (j == i) continue;
                    sum -= inputMatrix[i][j] * previousIterationResult[j].doubleValue();
                }
                currentIterationResult[i] = 1.0 / inputMatrix[i][i] * sum;
            }
            if (++iterations == 1) ** continue;
            stop = true;
            for (i = 0; i < inputSize && stop; ++i) {
                if (!(Math.abs(currentIterationResult[i].doubleValue() - previousIterationResult[i].doubleValue()) > epsilon)) continue;
                stop = false;
            }
            if (((Boolean)this.xmcdaProperties.getParameter(Parameters.WithSmallestError)).booleanValue() && iterations >= 2) {
                error = this.heuristicMethodManager.calculateError((Double[])currentIterationResult, pairsComparisons, alternativesWeights, this.hreResultConverter.convertToResult(alternativesWeights, (Double[])previousIterationResult));
                if (smallestError == null || error < smallestError) {
                    smallestError = error;
                    resultWithLowestError = (Double[])currentIterationResult.clone();
                }
            }
            if (stop || iterations >= (Integer)this.xmcdaProperties.getParameter(Parameters.MaxIterations)) break;
            previousIterationResult = (Double[])currentIterationResult.clone();
            if (missingPairList.isEmpty()) ** continue;
            inputMatrix = this.updateMissingPairs(pairsComparisons, alternativesWeights, (Double[])previousIterationResult, missingPairList);
        }
        return (Boolean)this.xmcdaProperties.getParameter(Parameters.WithSmallestError) != false ? resultWithLowestError : previousIterationResult;
    }

    private Double[][] updateMissingPairs(Double[][] pairsComparisons, Double[] allAlternativesWeights, Double[] currentAlternativesWeights, List<Pair> missingPairList) {
        pairsComparisons = this.missingDataService.updateProposedPairs(pairsComparisons, this.hreResultConverter.convertToResult(allAlternativesWeights, currentAlternativesWeights), missingPairList);
        Double[] constants = this.jacobiParametersCreator.generateVectorOfConstants(pairsComparisons, allAlternativesWeights);
        Double[][] factors = this.jacobiParametersCreator.generateMatrixOfFactors(pairsComparisons, allAlternativesWeights);
        return this.prepareInputMatrix(factors, constants);
    }

    private Double[][] prepareInputMatrix(Double[][] factors, Double[] constants) {
        Double[][] tem = new Double[factors.length][factors.length + 1];
        for (int i = 0; i < factors.length; ++i) {
            for (int j = 0; j < factors.length + 1; ++j) {
                tem[i][j] = j != factors.length ? factors[i][j] : constants[i];
            }
        }
        return tem;
    }
}

