/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.io;

import com.juraszek.algorithm.io.DataLoader;
import com.juraszek.algorithm.io.InputsHandler;
import com.juraszek.algorithm.io.OutputsHandler;
import com.juraszek.algorithm.io.ProgramExecutionResultsService;
import com.juraszek.algorithm.models.HREModel;
import com.juraszek.algorithm.utils.xmcda.CmdLineParser;
import com.juraszek.algorithm.utils.xmcda.Version;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import java.io.File;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.converters.v2_v3.XMCDAConverter;
import org.xmcda.parsers.xml.xmcda_v2.XMCDAParser;
import org.xmcda.v2.XMCDA;

@Service(value="HreIOService")
public class IOService {
    @Autowired
    private DataLoader dataLoader;
    @Autowired
    private ProgramExecutionResultsService programExecutionResultsService;
    @Autowired
    private InputsHandler inputsHandler;
    @Autowired
    private OutputsHandler outputsHandler;

    public HREModel readInputs(CmdLineParser.Arguments params, ProgramExecutionResult executionResult, File prgExecResults) throws Exception {
        String inputDirectory = params.inputDirectory;
        org.xmcda.XMCDA xmcda = this.dataLoader.loadXMCDA(inputDirectory, executionResult);
        if (!executionResult.isOk() && !executionResult.isWarning()) {
            this.programExecutionResultsService.writeProgramExecutionResultsAndExit(prgExecResults, executionResult, "Invalid inputs.", params.xmcdaVersion);
        }
        HREModel inputs = this.inputsHandler.checkAndExtractInputs(xmcda, executionResult);
        if (!executionResult.isOk() && !executionResult.isWarning() || inputs == null) {
            this.programExecutionResultsService.writeProgramExecutionResultsAndExit(prgExecResults, executionResult, "Invalid inputs format.", params.xmcdaVersion);
        }
        return inputs;
    }

    public void writeOutput(CmdLineParser.Arguments params, HREModel model, ProgramExecutionResult executionResult, File prgExecResults) throws Throwable {
        if (params.xmcdaVersion == Version.v2) {
            this.writeOutputV2(params, model, executionResult, prgExecResults);
        } else if (params.xmcdaVersion == Version.v3) {
            this.writeOutputV3(params, model, executionResult, prgExecResults);
        }
    }

    private void writeOutputV3(CmdLineParser.Arguments params, HREModel model, ProgramExecutionResult executionResult, File prgExecResults) throws Throwable {
        Map<String, org.xmcda.XMCDA> results = this.outputsHandler.convert(model);
        org.xmcda.parsers.xml.xmcda_v3.XMCDAParser parser = new org.xmcda.parsers.xml.xmcda_v3.XMCDAParser();
        for (String key : results.keySet()) {
            File outputFile = new File(params.outputDirectory, String.format("%s.xml", key));
            try {
                parser.writeXMCDA(results.get(key), outputFile, this.outputsHandler.xmcdaV3Tag(key));
            }
            catch (Throwable throwable) {
                String err = String.format("Error while writing %s.xml, reason: ", key);
                executionResult.addError(XMCDAMessageParser.getMessage(err, throwable));
                outputFile.delete();
            }
        }
        this.programExecutionResultsService.writeProgramExecutionResults(prgExecResults, executionResult, params.xmcdaVersion);
    }

    private void writeOutputV2(CmdLineParser.Arguments params, HREModel model, ProgramExecutionResult executionResult, File prgExecResults) throws Throwable {
        Map<String, org.xmcda.XMCDA> results = this.outputsHandler.convert(model);
        XMCDAConverter.omit_values_in_alternativesValues = true;
        for (String key : results.keySet()) {
            XMCDA results_v2;
            File outputFile = new File(params.outputDirectory, String.format("%s.xml", key));
            try {
                results_v2 = XMCDAConverter.convertTo_v2(results.get(key));
                if (results_v2 == null) {
                    throw new IllegalStateException("Conversion from v3 to v2 returned a null value");
                }
            }
            catch (Throwable t) {
                executionResult.addError(XMCDAMessageParser.getMessage("Could not convert alternativesValues into XMCDA_v2, reason: ", t));
                this.programExecutionResultsService.writeProgramExecutionResults(prgExecResults, executionResult, params.xmcdaVersion);
                return;
            }
            try {
                XMCDAParser.writeXMCDA(results_v2, outputFile);
            }
            catch (Throwable t) {
                executionResult.addError(XMCDAMessageParser.getMessage("Error while writing alternativesValues.xml, reason: ", t));
                outputFile.delete();
                this.programExecutionResultsService.writeProgramExecutionResults(prgExecResults, executionResult, params.xmcdaVersion);
                return;
            }
        }
        this.programExecutionResultsService.writeProgramExecutionResults(prgExecResults, executionResult, params.xmcdaVersion);
    }
}

