/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.io;

import com.juraszek.algorithm.models.HREModel;
import com.juraszek.algorithm.utils.xmcda.Parameters;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import com.juraszek.algorithm.utils.xmcda.XMCDAProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xmcda.Alternative;
import org.xmcda.AlternativesValues;
import org.xmcda.LabelledQValues;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.utils.Coord;
import org.xmcda.utils.ValueConverters;

@Service
public class InputsHandler {
    @Autowired
    XMCDAProperties xmcdaProperties;

    public HREModel checkAndExtractInputs(XMCDA xmcda, ProgramExecutionResult executionResult) {
        this.checkInputs(xmcda, executionResult);
        if (executionResult.isError()) {
            return null;
        }
        return this.extractInputs(xmcda);
    }

    private HREModel extractInputs(XMCDA xmcda) {
        HREModel inputs = new HREModel();
        inputs.setAlternatives(this.extractAlternatives(xmcda));
        inputs.setAlternativesWeights(this.extractAlterantivesWeights(xmcda, inputs.getAlternatives()));
        inputs.setPairsComparisons(this.extractPairsComparisons(xmcda, inputs.getAlternatives()));
        this.extractParameters(xmcda);
        return inputs;
    }

    private Double[][] extractPairsComparisons(XMCDA xmcda, List<Alternative> alternatives) {
        Double[][] pairsComparisons = new Double[alternatives.size()][];
        for (int i = 0; i < alternatives.size(); ++i) {
            pairsComparisons[i] = new Double[alternatives.size()];
            for (int j = 0; j < alternatives.size(); ++j) {
                QualifiedValues qualifiedValues = (QualifiedValues)xmcda.alternativesMatricesList.get(0).get(new Coord<Alternative, Alternative>(alternatives.get(i), alternatives.get(j)));
                pairsComparisons[i][j] = qualifiedValues != null ? (Double)((QualifiedValue)qualifiedValues.get(0)).getValue() : null;
            }
        }
        return pairsComparisons;
    }

    private Double[] extractAlterantivesWeights(XMCDA xmcda, List<Alternative> alternatives) {
        Double[] alternativesWeights = new Double[alternatives.size()];
        for (int i = 0; i < alternatives.size(); ++i) {
            LabelledQValues qualifiedValues = (LabelledQValues)xmcda.alternativesValuesList.get(0).get(alternatives.get(i));
            alternativesWeights[i] = qualifiedValues != null ? (Double)((QualifiedValue)qualifiedValues.get(0)).getValue() : null;
        }
        return alternativesWeights;
    }

    private List<Alternative> extractAlternatives(XMCDA xmcda) {
        ArrayList<Alternative> alternatives = new ArrayList<Alternative>();
        for (Alternative alternative : xmcda.alternatives) {
            if (!alternative.isActive()) continue;
            alternatives.add(alternative);
        }
        return alternatives;
    }

    private void extractParameters(XMCDA xmcda) {
        if (xmcda.programParametersList.size() > 0) {
            xmcda.programParametersList.get(0).forEach(programParameter -> this.xmcdaProperties.setParameter(Parameters.valueOf(programParameter.id()), ((QualifiedValue)programParameter.getValues().get(0)).getValue()));
        }
    }

    private void checkInputs(XMCDA xmcda, ProgramExecutionResult errors) {
        this.checkAlternatives(xmcda, errors);
        this.checkAlternativesValues(xmcda, errors);
        this.checkAlternativesMatrix(xmcda, errors);
        this.checkParameters(xmcda, errors);
    }

    private void checkAlternativesMatrix(XMCDA xmcda, ProgramExecutionResult errors) {
        if (xmcda.alternativesMatricesList.size() == 0) {
            errors.addError("Alternative values matrix is empty");
        } else if (xmcda.alternativesMatricesList.size() > 1) {
            errors.addError("More than one alternative values matrix has been supplied");
        } else {
            xmcda.alternatives.getActiveAlternatives().forEach(alternative1 -> xmcda.alternatives.getActiveAlternatives().forEach(alternative2 -> {
                try {
                    QualifiedValues<Double> qualifiedValues;
                    QualifiedValues rawQualifiedValues = xmcda.alternativesMatricesList.get(0).get(alternative1, alternative2);
                    if (rawQualifiedValues != null && (qualifiedValues = rawQualifiedValues.convertToDouble()).size() != 1) {
                        String msg = "Error when converting the alternative matrix pairs to Double, reason: Pairs can only contain one value";
                        errors.addError("Error when converting the alternative matrix pairs to Double, reason: Pairs can only contain one value");
                    }
                }
                catch (ValueConverters.ConversionException e) {
                    String msg = "Error when converting the alternative matrix pairs to Double, reason:";
                    errors.addError(XMCDAMessageParser.getMessage("Error when converting the alternative matrix pairs to Double, reason:", e));
                }
            }));
        }
    }

    private void checkParameters(XMCDA xmcda, ProgramExecutionResult errors) {
        try {
            if (xmcda.programParametersList.size() > 0) {
                xmcda.programParametersList.get(0).forEach(programParameter -> Parameters.valueOf(programParameter.id()));
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid parameter name found, reason:";
            errors.addError(XMCDAMessageParser.getMessage("Invalid parameter name found, reason:", e));
        }
    }

    private void checkAlternativesValues(XMCDA xmcda, ProgramExecutionResult errors) {
        if (xmcda.alternativesValuesList.size() > 1) {
            errors.addError("More than one alternatives values vectors has been supplied");
        } else {
            try {
                if (xmcda.alternativesValuesList.isEmpty()) {
                    AlternativesValues<Double> doubleAlternativesValues = new AlternativesValues<Double>();
                    Alternative randomAlternative = xmcda.alternatives.getActiveAlternatives().get(0);
                    doubleAlternativesValues.put(randomAlternative, 1.0);
                    xmcda.alternativesValuesList.add(doubleAlternativesValues);
                } else {
                    AlternativesValues<Double> doubleAlternativesValues = xmcda.alternativesValuesList.get(0).asDouble();
                    xmcda.alternativesValuesList.set(0, doubleAlternativesValues);
                }
            }
            catch (Exception e) {
                String msg = "Error when converting the alternative values to Double, reason:";
                errors.addError(XMCDAMessageParser.getMessage("Error when converting the alternative values to Double, reason:", e));
            }
        }
    }

    private void checkAlternatives(XMCDA xmcda, ProgramExecutionResult errors) {
        if (xmcda.alternatives.size() == 0) {
            errors.addError("No alternatives has been supplied");
        }
    }
}

