/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.io;

import com.juraszek.algorithm.utils.xmcda.Version;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;
import org.xmcda.Message;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.converters.v2_v3.XMCDAConverter;
import org.xmcda.parsers.xml.xmcda_v2.XMCDAParser;
import org.xmcda.v2.XMCDA;

@Service
public class ProgramExecutionResultsService {
    public void writeProgramExecutionResults(File prgExecResultsFile, ProgramExecutionResult errors, Version version) throws Throwable {
        org.xmcda.parsers.xml.xmcda_v3.XMCDAParser parser = new org.xmcda.parsers.xml.xmcda_v3.XMCDAParser();
        org.xmcda.XMCDA prgExecResults = new org.xmcda.XMCDA();
        prgExecResults.programExecutionResultsList.add(errors);
        switch (version) {
            case v3: {
                parser.writeXMCDA(prgExecResults, prgExecResultsFile, "programExecutionResult");
                break;
            }
            case v2: {
                if (errors.isOk()) {
                    ProgramExecutionResult messages = new ProgramExecutionResult();
                    messages.add(new Message(Message.Level.INFO, "ok"));
                    prgExecResults.programExecutionResultsList.clear();
                    prgExecResults.programExecutionResultsList.add(messages);
                }
                XMCDA xmcda_v2 = XMCDAConverter.convertTo_v2(prgExecResults);
                XMCDAParser.writeXMCDA(xmcda_v2, prgExecResultsFile, "methodMessages");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled XMCDA version " + version.toString());
            }
        }
    }

    public void writeProgramExecutionResultsAndExit(File prgExecResultsFile, ProgramExecutionResult errors, String message, Version version) throws Exception {
        try {
            this.cleanOutputDirectory(prgExecResultsFile);
            this.writeProgramExecutionResults(prgExecResultsFile, errors, version);
        }
        catch (Throwable t) {
            System.err.println(XMCDAMessageParser.getMessage("Could not write messages.xml, reason: ", t));
            System.exit(ProgramExecutionResult.Status.ERROR.exitStatus());
        }
        throw new Exception(message);
    }

    private void cleanOutputDirectory(File prgExecResultsFile) {
        try {
            File parent = prgExecResultsFile.getParentFile();
            FileUtils.cleanDirectory(parent);
        }
        catch (IOException e) {
            System.err.println(XMCDAMessageParser.getMessage("Could not remove all files from output directory, reason: ", e));
        }
    }
}

