/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.io.parsers;

import com.juraszek.algorithm.io.parsers.Parser;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import java.io.File;
import javax.xml.bind.JAXBElement;
import org.xmcda.Alternative;
import org.xmcda.AlternativesMatrix;
import org.xmcda.Factory;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.ScaleConverter;
import org.xmcda.converters.v2_v3.XMCDAConverter;
import org.xmcda.parsers.xml.xmcda_v2.XMCDAParser;
import org.xmcda.utils.Coord;
import org.xmcda.v2.AlternativesMatrix;
import org.xmcda.v2.AlternativesSet;
import org.xmcda.v2.XMCDA;
import org.xmcda.value.NA;

public class V2Parser
implements Parser {
    @Override
    public org.xmcda.XMCDA loadXMCDA(String inputDirectory, ProgramExecutionResult executionResult) {
        XMCDA xmcda_v2 = new XMCDA();
        this.loadXMCDA(xmcda_v2, new File(inputDirectory, "alternatives.xml"), false, executionResult, "alternatives");
        this.loadXMCDA(xmcda_v2, new File(inputDirectory, "alternativesMatrix.xml"), true, executionResult, "alternativesMatrix");
        this.loadXMCDA(xmcda_v2, new File(inputDirectory, "knownRankings.xml"), false, executionResult, "alternativesValues");
        this.loadXMCDA(xmcda_v2, new File(inputDirectory, "parameters.xml"), true, executionResult, "programParameters");
        org.xmcda.XMCDA xmcda = new org.xmcda.XMCDA();
        try {
            xmcda = XMCDAConverter.convertTo_v3(xmcda_v2);
            for (JAXBElement<?> o : xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters()) {
                JAXBElement<?> element = o;
                if (!(element.getValue() instanceof org.xmcda.v2.AlternativesMatrix)) continue;
                this.convertTo_v3((org.xmcda.v2.AlternativesMatrix)element.getValue(), xmcda);
            }
        }
        catch (Throwable t) {
            executionResult.addError(XMCDAMessageParser.getMessage("Could not convert inputs to XMCDA v3, reason: ", t));
        }
        return xmcda;
    }

    private void loadXMCDA(XMCDA xmcda_v2, File file, boolean mandatory, ProgramExecutionResult executionResults, String ... loadTags) {
        String baseFilename = file.getName();
        if (!file.exists()) {
            if (mandatory) {
                executionResults.addError("Could not find the mandatory file " + baseFilename);
                return;
            }
            return;
        }
        try {
            xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters().addAll(XMCDAParser.readXMCDA(file).getProjectReferenceOrMethodMessagesOrMethodParameters());
        }
        catch (Throwable throwable) {
            String msg = String.format("Unable to read & parse the file %s, reason: ", baseFilename);
            executionResults.addError(XMCDAMessageParser.getMessage(msg, throwable));
        }
    }

    private void convertTo_v3(org.xmcda.v2.AlternativesMatrix value, org.xmcda.XMCDA xmcda_v3) {
        AlternativesMatrix alternativesMatrix_v3 = Factory.alternativesMatrix();
        alternativesMatrix_v3.setId(value.getId());
        alternativesMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        alternativesMatrix_v3.setName(value.getName());
        alternativesMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            alternativesMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        for (AlternativesMatrix.Row row_v2 : value.getRow()) {
            String row_alternativeID = row_v2.getAlternativeID();
            String row_alternativeSetID = row_v2.getAlternativesSetID();
            AlternativesSet row_alternativeSet_v2 = row_v2.getAlternativesSet();
            Alternative row_alternative = (Alternative)xmcda_v3.alternatives.get(row_alternativeID, true);
            for (AlternativesMatrix.Row.Column column_v2 : row_v2.getColumn()) {
                QualifiedValue<NA> value_v3;
                String column_alternativeID = column_v2.getAlternativeID();
                String column_alternativeSetID = column_v2.getAlternativesSetID();
                AlternativesSet column_alternativeSet_v2 = row_v2.getAlternativesSet();
                Alternative column_alternative = (Alternative)xmcda_v3.alternatives.get(column_alternativeID, true);
                if (column_v2.getValue() == null) {
                    value_v3 = Factory.qualifiedValue();
                    value_v3.setValue(NA.na);
                } else {
                    value_v3 = new QualifiedValueConverter().convertTo_v3(column_v2.getValue(), xmcda_v3);
                }
                Coord<Alternative, Alternative> coord_v3 = new Coord<Alternative, Alternative>(row_alternative, column_alternative);
                QualifiedValues values_v3 = Factory.qualifiedValues();
                values_v3.add(value_v3);
                alternativesMatrix_v3.put(coord_v3, values_v3);
            }
        }
        xmcda_v3.alternativesMatricesList.add(alternativesMatrix_v3);
    }
}

