/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.utils;

import com.juraszek.algorithm.utils.MathUtils;
import java.util.Arrays;
import org.springframework.stereotype.Service;

@Service
public class HREResultConverter {
    public Double[] convertToResult(Double[] c, Double[] jacobiResult) {
        int jacobiResultIndex = 0;
        Double[] result = new Double[c.length];
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != null) {
                result[i] = c[i];
                continue;
            }
            result[i] = jacobiResult[jacobiResultIndex];
            ++jacobiResultIndex;
        }
        return result;
    }

    public Double[] normalizeResult(Double[] result) {
        Double sum = MathUtils.sum(result);
        return (Double[])Arrays.stream(result).map(aDouble -> MathUtils.round(aDouble / sum, 3)).toArray(Double[]::new);
    }

    public Double[] rescaleResult(Double[] jacobiResult) {
        return (Double[])Arrays.stream(jacobiResult).map(aDouble -> Math.pow(10.0, aDouble)).toArray(Double[]::new);
    }
}

