/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.utils.xmcda;

import com.juraszek.algorithm.utils.xmcda.Version;
import org.springframework.stereotype.Service;

@Service(value="CmdLineParser")
public class CmdLineParser {
    public Arguments parseCmdLineArguments(String[] args) throws InvalidCommandLineException {
        if (args.length != 5) {
            throw new InvalidCommandLineException("Invalid number of arguments");
        }
        Arguments arguments = new Arguments();
        for (int index = 0; index <= 4; index += 2) {
            String arg = args[index];
            if ("-i".equals(arg) || "--input-directory".equals(arg)) {
                arguments.inputDirectory = args[index + 1];
                continue;
            }
            if ("-o".equals(arg) || "--output-directory".equals(arg)) {
                arguments.outputDirectory = args[index + 1];
                continue;
            }
            if ("--v2".equals(arg)) {
                arguments.xmcdaVersion = Version.v2;
                continue;
            }
            if (!"--v3".equals(arg)) continue;
            arguments.xmcdaVersion = Version.v3;
        }
        if (arguments.inputDirectory == null || arguments.outputDirectory == null || arguments.xmcdaVersion == null) {
            throw new InvalidCommandLineException("Missing parameters");
        }
        return arguments;
    }

    public static class Arguments {
        public String inputDirectory;
        public String outputDirectory;
        public Version xmcdaVersion;
    }

    static class InvalidCommandLineException
    extends Exception {
        private static final long serialVersionUID = 3991185595688176975L;

        InvalidCommandLineException(String message) {
            super(message);
        }
    }
}

