/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.utils.xmcda;

import com.juraszek.algorithm.heuristics.CalculationMethod;
import com.juraszek.algorithm.heuristics.methods.ArithmeticMethod;
import com.juraszek.algorithm.heuristics.methods.GeometricMethod;
import com.juraszek.algorithm.heuristics.methods.HeuristicMethod;
import com.juraszek.algorithm.heuristics.methods.HeuristicMethodManager;
import com.juraszek.algorithm.heuristics.methods.MinimizingEstimationErrorMethod;
import com.juraszek.algorithm.io.DataLoader;
import com.juraszek.algorithm.io.ProgramExecutionResultsService;
import com.juraszek.algorithm.io.parsers.Parser;
import com.juraszek.algorithm.io.parsers.V2Parser;
import com.juraszek.algorithm.io.parsers.V3Parser;
import com.juraszek.algorithm.utils.xmcda.Parameters;
import com.juraszek.algorithm.utils.xmcda.Version;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xmcda.ProgramExecutionResult;

@Service
public class XMCDAProperties {
    @Autowired
    private HeuristicMethodManager heuristicMethodManager;
    @Autowired
    DataLoader dataLoader;
    private Map<Parameters, Object> parameters = new HashMap<Parameters, Object>();
    @Autowired
    private ProgramExecutionResultsService programExecutionResultsService;

    public XMCDAProperties() {
        this.setDefaultParams();
    }

    private void setDefaultParams() {
        this.parameters.put(Parameters.MaxIterations, 100);
        this.parameters.put(Parameters.NormalizeResults, true);
        this.parameters.put(Parameters.WithSmallestError, false);
        this.parameters.put(Parameters.TryToReciprocalMatrix, false);
        this.parameters.put(Parameters.CalculationMethod, "Arithmetic");
    }

    public void setParameter(Parameters parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    public Object getParameter(Parameters parameter) {
        return this.parameters.get((Object)parameter);
    }

    public void initHeuristicMethod(ProgramExecutionResult executionResult, File prgExecResults, Version xmcdaVersion) throws Exception {
        try {
            this.heuristicMethodManager.setMethod(this.getMethod());
        }
        catch (Throwable t) {
            String message = XMCDAMessageParser.getMessage("The calculation could not be performed, reason: ", t);
            executionResult.addError(message);
            this.programExecutionResultsService.writeProgramExecutionResultsAndExit(prgExecResults, executionResult, message, xmcdaVersion);
        }
    }

    private HeuristicMethod getMethod() throws Exception {
        if (CalculationMethod.MinimizingEstimationError.name().equals(this.parameters.get((Object)Parameters.CalculationMethod))) {
            return new MinimizingEstimationErrorMethod();
        }
        if (CalculationMethod.Geometric.name().equals(this.parameters.get((Object)Parameters.CalculationMethod))) {
            return new GeometricMethod();
        }
        if (CalculationMethod.Arithmetic.name().equals(this.parameters.get((Object)Parameters.CalculationMethod))) {
            return new ArithmeticMethod();
        }
        throw new Exception("Invalid calculation method: " + this.parameters.get((Object)Parameters.CalculationMethod));
    }

    public void initXMCDAVersion(ProgramExecutionResult executionResult, File prgExecResults, Version xmcdaVersion) throws Exception {
        try {
            this.dataLoader.setParser(this.getParser(xmcdaVersion));
        }
        catch (Throwable t) {
            String message = XMCDAMessageParser.getMessage("The calculation could not be performed, reason: ", t);
            executionResult.addError(message);
            this.programExecutionResultsService.writeProgramExecutionResultsAndExit(prgExecResults, executionResult, message, xmcdaVersion);
        }
    }

    private Parser getParser(Version xmcdaVersion) throws Exception {
        if (xmcdaVersion.equals((Object)Version.v3)) {
            return new V3Parser();
        }
        if (xmcdaVersion.equals((Object)Version.v2)) {
            return new V2Parser();
        }
        throw new Exception("Invalid xmcda version: " + (Object)((Object)xmcdaVersion));
    }
}

