/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jackson.JsonComponentModule;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
public class JacksonAutoConfiguration {
    @Bean
    public JsonComponentModule jsonComponentModule() {
        return new JsonComponentModule();
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    @EnableConfigurationProperties(value={JacksonProperties.class})
    static class Jackson2ObjectMapperBuilderCustomizerConfiguration {
        Jackson2ObjectMapperBuilderCustomizerConfiguration() {
        }

        @Bean
        public StandardJackson2ObjectMapperBuilderCustomizer standardJacksonObjectMapperBuilderCustomizer(ApplicationContext applicationContext, JacksonProperties jacksonProperties) {
            return new StandardJackson2ObjectMapperBuilderCustomizer(applicationContext, jacksonProperties);
        }

        private static final class StandardJackson2ObjectMapperBuilderCustomizer
        implements Jackson2ObjectMapperBuilderCustomizer,
        Ordered {
            private final ApplicationContext applicationContext;
            private final JacksonProperties jacksonProperties;

            StandardJackson2ObjectMapperBuilderCustomizer(ApplicationContext applicationContext, JacksonProperties jacksonProperties) {
                this.applicationContext = applicationContext;
                this.jacksonProperties = jacksonProperties;
            }

            @Override
            public int getOrder() {
                return 0;
            }

            @Override
            public void customize(Jackson2ObjectMapperBuilder builder) {
                if (this.jacksonProperties.getDefaultPropertyInclusion() != null) {
                    builder.serializationInclusion(this.jacksonProperties.getDefaultPropertyInclusion());
                }
                if (this.jacksonProperties.getTimeZone() != null) {
                    builder.timeZone(this.jacksonProperties.getTimeZone());
                }
                this.configureFeatures(builder, this.jacksonProperties.getDeserialization());
                this.configureFeatures(builder, this.jacksonProperties.getSerialization());
                this.configureFeatures(builder, this.jacksonProperties.getMapper());
                this.configureFeatures(builder, this.jacksonProperties.getParser());
                this.configureFeatures(builder, this.jacksonProperties.getGenerator());
                this.configureDateFormat(builder);
                this.configurePropertyNamingStrategy(builder);
                this.configureModules(builder);
                this.configureLocale(builder);
            }

            private void configureFeatures(Jackson2ObjectMapperBuilder builder, Map<?, Boolean> features) {
                for (Map.Entry<?, Boolean> entry : features.entrySet()) {
                    if (entry.getValue() != null && entry.getValue().booleanValue()) {
                        builder.featuresToEnable(new Object[]{entry.getKey()});
                        continue;
                    }
                    builder.featuresToDisable(new Object[]{entry.getKey()});
                }
            }

            private void configureDateFormat(Jackson2ObjectMapperBuilder builder) {
                String dateFormat = this.jacksonProperties.getDateFormat();
                if (dateFormat != null) {
                    try {
                        Class<?> dateFormatClass = ClassUtils.forName(dateFormat, null);
                        builder.dateFormat((DateFormat)BeanUtils.instantiateClass(dateFormatClass));
                    }
                    catch (ClassNotFoundException ex) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                        TimeZone timeZone = this.jacksonProperties.getTimeZone();
                        if (timeZone == null) {
                            timeZone = new ObjectMapper().getSerializationConfig().getTimeZone();
                        }
                        simpleDateFormat.setTimeZone(timeZone);
                        builder.dateFormat((DateFormat)simpleDateFormat);
                    }
                }
            }

            private void configurePropertyNamingStrategy(Jackson2ObjectMapperBuilder builder) {
                String strategy = this.jacksonProperties.getPropertyNamingStrategy();
                if (strategy != null) {
                    try {
                        this.configurePropertyNamingStrategyClass(builder, ClassUtils.forName(strategy, null));
                    }
                    catch (ClassNotFoundException ex) {
                        this.configurePropertyNamingStrategyField(builder, strategy);
                    }
                }
            }

            private void configurePropertyNamingStrategyClass(Jackson2ObjectMapperBuilder builder, Class<?> propertyNamingStrategyClass) {
                builder.propertyNamingStrategy((PropertyNamingStrategy)BeanUtils.instantiateClass(propertyNamingStrategyClass));
            }

            private void configurePropertyNamingStrategyField(Jackson2ObjectMapperBuilder builder, String fieldName) {
                Field field = ReflectionUtils.findField(PropertyNamingStrategy.class, fieldName, PropertyNamingStrategy.class);
                Assert.notNull(field, "Constant named '" + fieldName + "' not found on " + PropertyNamingStrategy.class.getName());
                try {
                    builder.propertyNamingStrategy((PropertyNamingStrategy)field.get(null));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            private void configureModules(Jackson2ObjectMapperBuilder builder) {
                Collection<Module> moduleBeans = StandardJackson2ObjectMapperBuilderCustomizer.getBeans(this.applicationContext, Module.class);
                builder.modulesToInstall(moduleBeans.toArray(new Module[moduleBeans.size()]));
            }

            private void configureLocale(Jackson2ObjectMapperBuilder builder) {
                Locale locale = this.jacksonProperties.getLocale();
                if (locale != null) {
                    builder.locale(locale);
                }
            }

            private static <T> Collection<T> getBeans(ListableBeanFactory beanFactory, Class<T> type) {
                return BeanFactoryUtils.beansOfTypeIncludingAncestors(beanFactory, type).values();
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    static class JacksonObjectMapperBuilderConfiguration {
        private final ApplicationContext applicationContext;

        JacksonObjectMapperBuilderConfiguration(ApplicationContext applicationContext, JacksonProperties jacksonProperties, List<Jackson2ObjectMapperBuilderCustomizer> customizers) {
            this.applicationContext = applicationContext;
        }

        @Bean
        @ConditionalOnMissingBean(value={Jackson2ObjectMapperBuilder.class})
        public Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder(List<Jackson2ObjectMapperBuilderCustomizer> customizers) {
            Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
            builder.applicationContext(this.applicationContext);
            this.customize(builder, customizers);
            return builder;
        }

        private void customize(Jackson2ObjectMapperBuilder builder, List<Jackson2ObjectMapperBuilderCustomizer> customizers) {
            for (Jackson2ObjectMapperBuilderCustomizer customizer : customizers) {
                customizer.customize(builder);
            }
        }
    }

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT)
    @ConditionalOnClass(value={ParameterNamesModule.class})
    static class ParameterNamesModuleConfiguration {
        ParameterNamesModuleConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ParameterNamesModule.class})
        public ParameterNamesModule parameterNamesModule() {
            return new ParameterNamesModule(JsonCreator.Mode.DEFAULT);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class, DateTime.class, DateTimeSerializer.class, JacksonJodaDateFormat.class})
    static class JodaDateTimeJacksonConfiguration {
        private static final Log logger = LogFactory.getLog(JodaDateTimeJacksonConfiguration.class);
        private final JacksonProperties jacksonProperties;

        JodaDateTimeJacksonConfiguration(JacksonProperties jacksonProperties) {
            this.jacksonProperties = jacksonProperties;
        }

        @Bean
        public SimpleModule jodaDateTimeSerializationModule() {
            SimpleModule module = new SimpleModule();
            JacksonJodaDateFormat jacksonJodaFormat = this.getJacksonJodaDateFormat();
            if (jacksonJodaFormat != null) {
                module.addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer(jacksonJodaFormat));
            }
            return module;
        }

        private JacksonJodaDateFormat getJacksonJodaDateFormat() {
            block4: {
                if (this.jacksonProperties.getJodaDateTimeFormat() != null) {
                    return new JacksonJodaDateFormat(DateTimeFormat.forPattern((String)this.jacksonProperties.getJodaDateTimeFormat()).withZoneUTC());
                }
                if (this.jacksonProperties.getDateFormat() != null) {
                    try {
                        return new JacksonJodaDateFormat(DateTimeFormat.forPattern((String)this.jacksonProperties.getDateFormat()).withZoneUTC());
                    }
                    catch (IllegalArgumentException ex) {
                        if (!logger.isWarnEnabled()) break block4;
                        logger.warn("spring.jackson.date-format could not be used to configure formatting of Joda's DateTime. You may want to configure spring.jackson.joda-date-time-format as well.");
                    }
                }
            }
            return null;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    static class JacksonObjectMapperConfiguration {
        JacksonObjectMapperConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean(value={ObjectMapper.class})
        public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
            return builder.createXmlMapper(false).build();
        }
    }
}

