/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction.jta;

import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.UserTransaction;
import java.io.File;
import javax.jms.Message;
import javax.transaction.TransactionManager;
import org.jboss.narayana.jta.jms.TransactionHelper;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ApplicationHome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jta.XAConnectionFactoryWrapper;
import org.springframework.boot.jta.XADataSourceWrapper;
import org.springframework.boot.jta.narayana.NarayanaBeanFactoryPostProcessor;
import org.springframework.boot.jta.narayana.NarayanaConfigurationBean;
import org.springframework.boot.jta.narayana.NarayanaProperties;
import org.springframework.boot.jta.narayana.NarayanaRecoveryManagerBean;
import org.springframework.boot.jta.narayana.NarayanaXAConnectionFactoryWrapper;
import org.springframework.boot.jta.narayana.NarayanaXADataSourceWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JtaTransactionManager.class, UserTransaction.class, XAResourceRecoveryRegistry.class})
@ConditionalOnMissingBean(value={PlatformTransactionManager.class})
@EnableConfigurationProperties(value={JtaProperties.class})
public class NarayanaJtaConfiguration {
    private final JtaProperties jtaProperties;
    private final TransactionManagerCustomizers transactionManagerCustomizers;

    public NarayanaJtaConfiguration(JtaProperties jtaProperties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.jtaProperties = jtaProperties;
        this.transactionManagerCustomizers = transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public NarayanaProperties narayanaProperties() {
        return new NarayanaProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public NarayanaConfigurationBean narayanaConfiguration(NarayanaProperties properties) {
        properties.setLogDir(this.getLogDir().getAbsolutePath());
        if (this.jtaProperties.getTransactionManagerId() != null) {
            properties.setTransactionManagerId(this.jtaProperties.getTransactionManagerId());
        }
        return new NarayanaConfigurationBean(properties);
    }

    private File getLogDir() {
        if (StringUtils.hasLength(this.jtaProperties.getLogDir())) {
            return new File(this.jtaProperties.getLogDir());
        }
        File home = new ApplicationHome().getDir();
        return new File(home, "transaction-logs");
    }

    @Bean
    @DependsOn(value={"narayanaConfiguration"})
    @ConditionalOnMissingBean
    public javax.transaction.UserTransaction narayanaUserTransaction() {
        return UserTransaction.userTransaction();
    }

    @Bean
    @DependsOn(value={"narayanaConfiguration"})
    @ConditionalOnMissingBean
    public TransactionManager narayanaTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    @Bean
    @DependsOn(value={"narayanaConfiguration"})
    public RecoveryManagerService narayanaRecoveryManagerService() {
        return new RecoveryManagerService();
    }

    @Bean
    @ConditionalOnMissingBean
    public NarayanaRecoveryManagerBean narayanaRecoveryManager(RecoveryManagerService recoveryManagerService) {
        return new NarayanaRecoveryManagerBean(recoveryManagerService);
    }

    @Bean
    public JtaTransactionManager transactionManager(javax.transaction.UserTransaction userTransaction, TransactionManager transactionManager) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(userTransaction, transactionManager);
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)jtaTransactionManager);
        }
        return jtaTransactionManager;
    }

    @Bean
    @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
    public XADataSourceWrapper xaDataSourceWrapper(NarayanaRecoveryManagerBean narayanaRecoveryManagerBean, NarayanaProperties narayanaProperties) {
        return new NarayanaXADataSourceWrapper(narayanaRecoveryManagerBean, narayanaProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public static NarayanaBeanFactoryPostProcessor narayanaBeanFactoryPostProcessor() {
        return new NarayanaBeanFactoryPostProcessor();
    }

    @Configuration
    @ConditionalOnClass(value={Message.class, TransactionHelper.class})
    static class NarayanaJtaJmsConfiguration {
        NarayanaJtaJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        public NarayanaXAConnectionFactoryWrapper xaConnectionFactoryWrapper(TransactionManager transactionManager, NarayanaRecoveryManagerBean narayanaRecoveryManagerBean, NarayanaProperties narayanaProperties) {
            return new NarayanaXAConnectionFactoryWrapper(transactionManager, narayanaRecoveryManagerBean, narayanaProperties);
        }
    }
}

