/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.io.Serializable;
import org.xmcda.Description;
import org.xmcda.HasDescription;
import org.xmcda.Referenceable;

public class Alternative
implements Referenceable,
HasDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Referenceable.CreationObserver creationObserver = Referenceable.defaultCreationObserver;
    private boolean isReal = true;
    private boolean isActive = true;
    private Description description;
    private String id;
    private String name;
    private String mcdaConcept;
    private Object marker;
    private transient Object container;

    public Alternative(String id) {
        this.setId(id);
        if (creationObserver != null) {
            creationObserver.objectCreated(this);
        }
    }

    @Override
    public void merge(Referenceable object) {
        if (!(object instanceof Alternative)) {
            throw new IllegalArgumentException("Argument should be an Alternative");
        }
        Alternative alternative = (Alternative)object;
        if (!this.id().equals(alternative.id())) {
            throw new IllegalArgumentException("Parameter's id() should be the same as this'");
        }
        this.isReal = alternative.isReal;
        this.isActive = alternative.isActive;
        this.setDescription(alternative.getDescription());
        this.setName(alternative.name());
        this.setMcdaConcept(alternative.mcdaConcept());
    }

    public boolean isReal() {
        return this.isReal;
    }

    public boolean isFictive() {
        return !this.isReal;
    }

    public void setIsReal(boolean isReal) {
        this.isReal = isReal;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public void activate() {
        this.isActive = true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Alternative)) {
            return false;
        }
        Alternative alt = (Alternative)obj;
        return this.id().equals(alt.id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Alternative id:");
        sb.append(this.id()).append(" name:").append(this.name()).append(" mcdaConcept:").append(this.mcdaConcept());
        sb.append(" isActive:").append(this.isActive).append(" isReal:").append(this.isReal);
        return sb.toString();
    }

    public static void main(String[] args) {
        Alternative a1 = new Alternative("a01");
        Alternative a2 = new Alternative("a02");
        a1.setName("name01");
        a2.setName("name02");
        System.out.println(a1.name());
        System.out.println(a2.name());
        System.out.println(a1.name());
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public String id() {
        return this.id;
    }

    void _setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setId(String id) {
        if (this.container != null) {
            throw new IllegalStateException("Cannot change this object's id while it's in a container");
        }
        this._setId(id);
    }

    @Override
    public void setContainer(Object container) {
        if (container == null) {
            this.container = null;
            return;
        }
        if (this.container != null && this.container != container) {
            throw new IllegalStateException("this object already belongs to a other alternatives");
        }
        this.container = container;
    }

    public Object getContainer() {
        return this.container;
    }

    @Override
    public void setMarker(Object marker) {
        this.marker = marker;
    }

    @Override
    public Object getMarker() {
        return this.marker;
    }
}

