/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.util.ArrayList;
import java.util.List;
import org.xmcda.Alternative;
import org.xmcda.CommonAttributes;
import org.xmcda.HasDescription;
import org.xmcda.ReferenceableContainer;
import org.xmcda.XMCDARootElement;

public class Alternatives
extends ReferenceableContainer<Alternative>
implements CommonAttributes,
HasDescription,
XMCDARootElement {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "alternatives";

    @Override
    public Class<Alternative> elementClass() {
        return Alternative.class;
    }

    public List<Alternative> getActiveAlternatives() {
        ArrayList<Alternative> activeAlternatives = new ArrayList<Alternative>(this);
        for (Alternative alternative : this) {
            if (alternative.isActive()) continue;
            activeAlternatives.remove(alternative);
        }
        return activeAlternatives;
    }

    public int getNumberOfActiveAlternatives() {
        int nb_active = 0;
        for (Alternative alternative : this) {
            if (!alternative.isActive()) continue;
            ++nb_active;
        }
        return nb_active;
    }

    @Override
    public void merge(Alternatives alternatives) {
        for (Alternative alternative : alternatives) {
            this.merge(alternative);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Alternative alternative : this) {
            sb.append(alternative.toString()).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

