/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.util.ArrayList;
import java.util.List;
import org.xmcda.Category;
import org.xmcda.CommonAttributes;
import org.xmcda.HasDescription;
import org.xmcda.ReferenceableContainer;
import org.xmcda.XMCDARootElement;

public class Categories
extends ReferenceableContainer<Category>
implements CommonAttributes,
HasDescription,
XMCDARootElement {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "categories";

    @Override
    public Class<Category> elementClass() {
        return Category.class;
    }

    public List<Category> getActiveCategories() {
        ArrayList<Category> activeCategories = new ArrayList<Category>(this);
        for (Category category : this) {
            if (category.isActive()) continue;
            activeCategories.remove(category);
        }
        return activeCategories;
    }

    public int getNumberOfActiveCategories() {
        int nb_active = 0;
        for (Category category : this) {
            if (!category.isActive()) continue;
            ++nb_active;
        }
        return nb_active;
    }

    @Override
    public void merge(Categories categories) {
        for (Category category : categories) {
            this.merge(category);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Category category : this) {
            sb.append(category.toString()).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

