/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.util.LinkedHashMap;
import java.util.Set;
import org.xmcda.Category;
import org.xmcda.Description;
import org.xmcda.HasDescription;
import org.xmcda.QualifiedValues;
import org.xmcda.Referenceable;

public class CategoriesSet<VALUE_TYPE>
extends LinkedHashMap<Category, QualifiedValues<VALUE_TYPE>>
implements HasDescription,
Referenceable {
    private static final long serialVersionUID = 1L;
    public static Referenceable.CreationObserver creationObserver = Referenceable.defaultCreationObserver;
    private Description description;
    private String id;
    private String name;
    private String mcdaConcept;
    private Object marker;
    private transient Object container;

    public CategoriesSet() {
        if (creationObserver != null) {
            creationObserver.objectCreated(this);
        }
    }

    public CategoriesSet(String id) {
        this.setId(id);
        if (creationObserver != null) {
            creationObserver.objectCreated(this);
        }
    }

    public Set<Category> getElements() {
        return this.keySet();
    }

    @Override
    public void merge(Referenceable object) {
        if (!(object instanceof CategoriesSet)) {
            throw new IllegalArgumentException("Argument should be a CategoriesSet");
        }
        CategoriesSet categoriesSet = (CategoriesSet)object;
        if (!this.id().equals(categoriesSet.id())) {
            throw new IllegalArgumentException("Parameter's id() should be the same as this'");
        }
        this.setDescription(categoriesSet.getDescription());
        this.setName(categoriesSet.name());
        this.setMcdaConcept(categoriesSet.mcdaConcept());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CategoriesSet)) {
            return false;
        }
        CategoriesSet categoriesSet = (CategoriesSet)obj;
        return this.id().equals(categoriesSet.id());
    }

    @Override
    public int hashCode() {
        return this.id().hashCode();
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("CategorySet id:");
        str.append(this.id());
        if (this.name() != null) {
            str.append(" [name:").append(this.name()).append("]");
        }
        return str.toString();
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public String id() {
        return this.id;
    }

    void _setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setId(String id) {
        if (this.container != null) {
            throw new IllegalStateException("Cannot change this object's id while it's in a container");
        }
        this._setId(id);
    }

    @Override
    public void setContainer(Object container) {
        if (container == null) {
            this.container = null;
            return;
        }
        if (this.container != null && this.container != container) {
            throw new IllegalStateException("this object already belongs to a other alternatives");
        }
        this.container = container;
    }

    public Object getContainer() {
        return this.container;
    }

    @Override
    public void setMarker(Object marker) {
        this.marker = marker;
    }

    @Override
    public Object getMarker() {
        return this.marker;
    }
}

