/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.xmcda.Category;
import org.xmcda.CommonAttributes;
import org.xmcda.Description;
import org.xmcda.Factory;
import org.xmcda.HasDescription;
import org.xmcda.LabelledQValues;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDARootElement;
import org.xmcda.utils.ValueConverters;

public class CategoriesValues<VALUE_TYPE>
extends LinkedHashMap<Category, LabelledQValues<VALUE_TYPE>>
implements HasDescription,
CommonAttributes,
XMCDARootElement {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "categoriesValues";
    private String id;
    private String name;
    private String mcdaConcept;
    private Description description;

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public LabelledQValues<VALUE_TYPE> put(Category category, QualifiedValue<VALUE_TYPE> qvalue) {
        return this.put(category, new LabelledQValues<VALUE_TYPE>(qvalue));
    }

    @Override
    public LabelledQValues<VALUE_TYPE> put(Category category, VALUE_TYPE value) {
        if (value instanceof QualifiedValue) {
            return this.put(category, new LabelledQValues((QualifiedValue)value));
        }
        if (value instanceof LabelledQValues) {
            return super.put(category, (LabelledQValues)value);
        }
        return this.put(category, new LabelledQValues<VALUE_TYPE>(new QualifiedValue<VALUE_TYPE>(value)));
    }

    public LabelledQValues<VALUE_TYPE> setDefault(Category category, VALUE_TYPE defaultValue) {
        LabelledQValues values = (LabelledQValues)this.get(category);
        if (values == null) {
            values = Factory.labelledQValues();
            values.add(new QualifiedValue<VALUE_TYPE>(defaultValue));
            this.put(category, values);
        }
        return (LabelledQValues)this.get(category);
    }

    public boolean isNumeric() {
        for (LabelledQValues values : this.values()) {
            if (values.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public Set<Category> getCategories() {
        LinkedHashSet<Category> categories = new LinkedHashSet<Category>();
        for (Category c : this.keySet()) {
            categories.add(c);
        }
        return categories;
    }

    public CategoriesValues<Double> asDouble() throws ValueConverters.ConversionException {
        return this.convertTo(Double.class);
    }

    public <U> CategoriesValues<U> convertTo(Class<U> clazz) throws ValueConverters.ConversionException {
        for (QualifiedValues values : this.values()) {
            values.convertTo(clazz);
        }
        return this;
    }
}

