/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.io.Serializable;
import org.xmcda.Description;
import org.xmcda.HasDescription;
import org.xmcda.Referenceable;

public class Criterion
implements Referenceable,
HasDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Referenceable.CreationObserver creationObserver = Referenceable.defaultCreationObserver;
    private boolean isActive = true;
    private Description description;
    private String id;
    private String name;
    private String mcdaConcept;
    private Object marker;
    private transient Object container;

    public Criterion(String id) {
        this.setId(id);
        if (creationObserver != null) {
            creationObserver.objectCreated(this);
        }
    }

    public Criterion(String id, String name) {
        this.setId(id);
        this.setName(name);
        if (creationObserver != null) {
            creationObserver.objectCreated(this);
        }
    }

    @Override
    public void merge(Referenceable object) {
        if (!(object instanceof Criterion)) {
            throw new IllegalArgumentException("Argument should be a Criterion");
        }
        Criterion criterion = (Criterion)object;
        if (!this.id().equals(criterion.id())) {
            throw new IllegalArgumentException("Parameter's id() should be the same as this'");
        }
        this.isActive = criterion.isActive;
        this.setDescription(criterion.getDescription());
        this.setName(criterion.name());
        this.setMcdaConcept(criterion.mcdaConcept());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Criterion)) {
            return false;
        }
        Criterion criterion = (Criterion)obj;
        return this.id().equals(criterion.id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Criterion id:");
        str.append(this.id());
        if (this.name() != null) {
            str.append(" [name:").append(this.name()).append("]");
        }
        return str.toString();
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public String id() {
        return this.id;
    }

    void _setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setId(String id) {
        if (this.container != null) {
            throw new IllegalStateException("Cannot change this object's id while it's in a container");
        }
        this._setId(id);
    }

    @Override
    public void setContainer(Object container) {
        if (container == null) {
            this.container = null;
            return;
        }
        if (this.container != null && this.container != container) {
            throw new IllegalStateException("this object already belongs to a other alternatives");
        }
        this.container = container;
    }

    public Object getContainer() {
        return this.container;
    }

    @Override
    public void setMarker(Object marker) {
        this.marker = marker;
    }

    @Override
    public Object getMarker() {
        return this.marker;
    }
}

