/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.xmcda.Alternative;
import org.xmcda.CommonAttributes;
import org.xmcda.Criterion;
import org.xmcda.Description;
import org.xmcda.HasDescription;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDARootElement;
import org.xmcda.utils.PerformanceTableCoord;
import org.xmcda.utils.ValueConverters;

public class PerformanceTable<T>
extends LinkedHashMap<PerformanceTableCoord, QualifiedValues<T>>
implements CommonAttributes,
HasDescription,
XMCDARootElement {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "performanceTable";
    private String id;
    private String name;
    private String mcdaConcept;
    private Description description;

    public QualifiedValues<T> put(Alternative a, Criterion c, QualifiedValues<T> qvalues) {
        return this.put(new PerformanceTableCoord(a, c), qvalues);
    }

    public QualifiedValues<T> put(Alternative a, Criterion c, QualifiedValue<T> qvalue) {
        return this.put(new PerformanceTableCoord(a, c), new QualifiedValues<T>(qvalue));
    }

    public QualifiedValues<T> put(Alternative a, Criterion c, T value) {
        return this.put(new PerformanceTableCoord(a, c), new QualifiedValues<T>(new QualifiedValue<T>(value)));
    }

    public QualifiedValues<T> get(Alternative a, Criterion c) {
        return (QualifiedValues)this.get(new PerformanceTableCoord(a, c));
    }

    public QualifiedValue<T> getQValue(Alternative a, Criterion c) {
        QualifiedValues values = (QualifiedValues)this.get(new PerformanceTableCoord(a, c));
        if (values == null) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalStateException("More than one value at the requested coordinates");
        }
        return (QualifiedValue)values.get(0);
    }

    public T getValue(Alternative a, Criterion c) {
        QualifiedValue<T> qValue = this.getQValue(a, c);
        return qValue == null ? null : (T)qValue.getValue();
    }

    public void setValue(Alternative a, Criterion c, T value) {
        this.put(a, c, value);
    }

    public Set<Alternative> getAlternatives() {
        LinkedHashSet<Alternative> alternatives = new LinkedHashSet<Alternative>();
        for (PerformanceTableCoord coord : this.keySet()) {
            alternatives.add((Alternative)coord.x);
        }
        return alternatives;
    }

    public Set<Criterion> getCriteria() {
        LinkedHashSet<Criterion> criteria = new LinkedHashSet<Criterion>();
        for (PerformanceTableCoord coord : this.keySet()) {
            criteria.add((Criterion)coord.y);
        }
        return criteria;
    }

    public PerformanceTableCoord getCoord(Alternative alternative, Criterion criterion) {
        for (PerformanceTableCoord coord : this.keySet()) {
            if (!((Alternative)coord.x).equals(alternative) || !((Criterion)coord.y).equals(criterion)) continue;
            return coord;
        }
        return null;
    }

    public boolean isNumeric() {
        for (QualifiedValues values : this.values()) {
            if (values.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public boolean hasMissingValues() {
        return this.size() != this.getAlternatives().size() * this.getCriteria().size();
    }

    public PerformanceTable<Double> asDouble() throws ValueConverters.ConversionException {
        return this.convertTo(Double.class);
    }

    public <U> PerformanceTable<U> convertTo(Class<U> clazz) throws ValueConverters.ConversionException {
        for (QualifiedValues values : this.values()) {
            values.convertTo(clazz);
        }
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }
}

