/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.io.Serializable;
import java.util.ArrayList;
import org.xmcda.CommonAttributes;
import org.xmcda.Description;
import org.xmcda.HasDescription;
import org.xmcda.Message;
import org.xmcda.XMCDARootElement;

public class ProgramExecutionResult
extends ArrayList<Message>
implements HasDescription,
CommonAttributes,
Serializable,
XMCDARootElement {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "programExecutionResult";
    private Status status = Status.OK;
    private String id;
    private String name;
    private String mcdaConcept;
    private Description description;

    private static Status statusForMessageLevel(Message.Level level) {
        Status status = Status.OK;
        switch (level) {
            case DEBUG: 
            case INFO: {
                break;
            }
            case WARNING: {
                status = Status.WARNING;
                break;
            }
            case ERROR: {
                status = Status.ERROR;
            }
        }
        return status;
    }

    public Status getStatus() {
        return this.status;
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    private void setStatus(String status) {
        this.setStatus(Status.valueOf(status.toUpperCase()));
    }

    public void updateStatus(Status status) {
        if (status.compareTo(this.status) > 0) {
            this.status = status;
        }
    }

    public Status refreshStatus() {
        if (this.status == Status.TERMINATED) {
            return Status.TERMINATED;
        }
        this.status = Status.OK;
        for (Message message : this) {
            this.updateStatus(ProgramExecutionResult.statusForMessageLevel(message.getLevel()));
        }
        return this.status;
    }

    public void forceStatus(Status status) {
        this.status = status;
    }

    protected Message addMessage(Message.Level level, String text) {
        this.updateStatus(ProgramExecutionResult.statusForMessageLevel(level));
        Message msg = new Message(level, text);
        this.add(msg);
        return msg;
    }

    public Message addDebug(String text) {
        return this.addMessage(Message.Level.DEBUG, text);
    }

    public Message addInfo(String text) {
        return this.addMessage(Message.Level.INFO, text);
    }

    public Message addWarning(String text) {
        return this.addMessage(Message.Level.WARNING, text);
    }

    public Message addError(String text) {
        return this.addMessage(Message.Level.ERROR, text);
    }

    public boolean isOk() {
        return this.status.equals((Object)Status.OK);
    }

    public boolean isWarning() {
        return this.status.equals((Object)Status.WARNING);
    }

    public boolean isError() {
        return this.status.equals((Object)Status.ERROR);
    }

    public boolean isTerminated() {
        return this.status.equals((Object)Status.TERMINATED);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    public static enum Status {
        OK,
        WARNING,
        ERROR,
        TERMINATED;


        public int exitStatus() {
            switch (this) {
                case OK: 
                case WARNING: {
                    return 0;
                }
                case ERROR: {
                    return 1;
                }
                case TERMINATED: {
                    return 2;
                }
            }
            throw new RuntimeException("Unknown status :" + this.toString());
        }
    }
}

