/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.xmcda.CommonAttributes;
import org.xmcda.Description;
import org.xmcda.Factory;
import org.xmcda.HasDescription;
import org.xmcda.Referenceable;

public abstract class ReferenceableContainer<ELEMENT extends Referenceable>
extends LinkedHashSet<ELEMENT>
implements CommonAttributes,
HasDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    public boolean getCreates = true;
    private String id;
    private String name;
    private String mcdaConcept;
    private Description description;

    public abstract Class<ELEMENT> elementClass();

    public ELEMENT get(String id) {
        return this.get(id, this.getCreates);
    }

    public ELEMENT get(String id, boolean create) {
        for (Referenceable element : this) {
            if (!element.id().equals(id)) continue;
            return (ELEMENT)element;
        }
        if (!create) {
            return null;
        }
        Referenceable element = (Referenceable)Factory.build(this.elementClass(), id);
        this.add((ELEMENT)element);
        return (ELEMENT)element;
    }

    public ArrayList<String> getIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Referenceable element : this) {
            ids.add(element.id());
        }
        return ids;
    }

    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Referenceable element : this) {
            names.add(element.name());
        }
        return names;
    }

    public boolean contains(String id) {
        return this.get(id, false) != null;
    }

    public void merge(ELEMENT element) {
        if (this.add(element)) {
            return;
        }
        ELEMENT this_element = this.get(element.id());
        this_element.merge((Referenceable)element);
    }

    public boolean isVoid() {
        return this.size() == 0 && this.id() == null && this.name() == null && this.mcdaConcept() == null && this.getDescription() == null;
    }

    @Override
    public boolean add(ELEMENT e) {
        boolean r = super.add(e);
        if (r) {
            e.setContainer(this);
        }
        return r;
    }

    @Override
    public boolean addAll(Collection<? extends ELEMENT> elementsCollection) {
        boolean modified = false;
        Iterator<ELEMENT> it = elementsCollection.iterator();
        while (it.hasNext()) {
            if (!this.add((ELEMENT)((Referenceable)it.next()))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<ELEMENT> iterator() {
        final Iterator it = super.iterator();
        return new Iterator<ELEMENT>(){
            ELEMENT current = null;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ELEMENT next() {
                this.current = (Referenceable)it.next();
                return this.current;
            }

            @Override
            public void remove() {
                it.remove();
                this.current.setContainer(null);
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        boolean r = super.remove(o);
        if (r) {
            Referenceable a = (Referenceable)o;
            a.setContainer(null);
        }
        return r;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object o : collection) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }
}

