/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.Alternative;
import org.xmcda.AlternativesMatrix;
import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.ScaleConverter;
import org.xmcda.utils.Coord;
import org.xmcda.v2.AlternativesMatrix;
import org.xmcda.v2.AlternativesSet;
import org.xmcda.v2.Value;
import org.xmcda.v2.Values;
import org.xmcda.value.NA;

public class AlternativesMatrixConverter
extends Converter {
    public static final String ALTERNATIVES_COMPARISONS = "alternativesComparisons";
    public static final String ALTERNATIVES_MATRIX = "alternativesMatrix";
    public static final String PAIRS = "pairs";
    public static final String PAIR = "pair";

    public AlternativesMatrixConverter() {
        super(ALTERNATIVES_MATRIX);
    }

    public void convertTo_v3(org.xmcda.v2.AlternativesMatrix value, XMCDA xmcda_v3) {
        this.getWarnings().pushTag(ALTERNATIVES_MATRIX, value.getId());
        AlternativesMatrix alternativesMatrix_v3 = Factory.alternativesMatrix();
        alternativesMatrix_v3.setId(value.getId());
        alternativesMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        alternativesMatrix_v3.setName(value.getName());
        alternativesMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            alternativesMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        for (AlternativesMatrix.Row row_v2 : value.getRow()) {
            String row_alternativeID = row_v2.getAlternativeID();
            String row_alternativeSetID = row_v2.getAlternativesSetID();
            AlternativesSet row_alternativesSet_v2 = row_v2.getAlternativesSet();
            if (row_alternativeSetID != null || row_alternativesSet_v2 != null) {
                this.getWarnings().throwUnimplemented();
            }
            Alternative row_alternative = (Alternative)xmcda_v3.alternatives.get(row_alternativeID, true);
            for (AlternativesMatrix.Row.Column column_v2 : row_v2.getColumn()) {
                QualifiedValue<NA> value_v3;
                String column_alternativeID = column_v2.getAlternativeID();
                String column_alternativeSetID = column_v2.getAlternativesSetID();
                AlternativesSet column_alternativesSet_v2 = row_v2.getAlternativesSet();
                if (column_alternativeSetID != null || column_alternativesSet_v2 != null) {
                    this.getWarnings().throwUnimplemented();
                }
                Alternative column_alternative = (Alternative)xmcda_v3.alternatives.get(column_alternativeID, true);
                if (column_v2.getValue() == null) {
                    value_v3 = Factory.qualifiedValue();
                    value_v3.setValue(NA.na);
                } else {
                    value_v3 = new QualifiedValueConverter().convertTo_v3(column_v2.getValue(), xmcda_v3);
                }
                Coord<Alternative, Alternative> coord_v3 = new Coord<Alternative, Alternative>(row_alternative, column_alternative);
                QualifiedValues values_v3 = Factory.qualifiedValues();
                values_v3.add(value_v3);
                alternativesMatrix_v3.put(coord_v3, values_v3);
            }
        }
        this.getWarnings().popTag();
        xmcda_v3.alternativesMatricesList.add(alternativesMatrix_v3);
    }

    public void convertTo_v2(List<AlternativesMatrix<?>> alternativesMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (AlternativesMatrix<?> alternativesMatrix_v3 : alternativesMatrices_v3) {
            this.convertTo_v2(alternativesMatrix_v3, xmcda_v2);
        }
    }

    public void convertTo_v2(AlternativesMatrix alternativesMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag(ALTERNATIVES_MATRIX, alternativesMatrix_v3.id());
        org.xmcda.v2.AlternativesMatrix alternativesMatrix_v2 = new org.xmcda.v2.AlternativesMatrix();
        List<JAXBElement<?>> alts = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        alts.add(new JAXBElement(new QName(ALTERNATIVES_MATRIX), org.xmcda.v2.AlternativesMatrix.class, (Object)alternativesMatrix_v2));
        alternativesMatrix_v2.setId(alternativesMatrix_v3.id());
        alternativesMatrix_v2.setName(alternativesMatrix_v3.name());
        alternativesMatrix_v2.setMcdaConcept(alternativesMatrix_v3.mcdaConcept());
        alternativesMatrix_v2.setValuation(new ScaleConverter().convertTo_v2(alternativesMatrix_v3.getValuation()));
        for (Object _coord : alternativesMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            AlternativesMatrix.Row row_v2 = new AlternativesMatrix.Row();
            alternativesMatrix_v2.getRow().add(row_v2);
            AlternativesMatrix.Row.Column col_v2 = new AlternativesMatrix.Row.Column();
            row_v2.getColumn().add(col_v2);
            row_v2.setAlternativeID(((Alternative)coord.x).id());
            col_v2.setAlternativeID(((Alternative)coord.y).id());
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)alternativesMatrix_v3.get(_coord);
            if (values_v3 == null || values_v3.isEmpty()) continue;
            QualifiedValue value = (QualifiedValue)values_v3.get(0);
            Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
            col_v2.setValue(value_v2);
        }
        this.getWarnings().popTag();
    }
}

