/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import org.xmcda.BibliographyEntry;
import org.xmcda.Factory;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.v2.Bibliography;
import org.xmcda.v2.Description;

public class BibliographyConverter
extends Converter {
    public static final String BIBLIOGRAPHY = "bibliography";
    public static final String DESCRIPTION = "description";
    public static final String BIB_ENTRY = "bibEntry";

    public BibliographyConverter() {
        super(BIBLIOGRAPHY);
    }

    public BibliographyEntry convertTo_v3(Bibliography bibliography) {
        if (bibliography == null) {
            return null;
        }
        this.getWarnings().pushTag(BIBLIOGRAPHY, bibliography.getId());
        BibliographyEntry bibEntry = Factory.bibliographyEntry();
        bibEntry.setId(bibliography.getId());
        bibEntry.setName(bibliography.getName());
        bibEntry.setMcdaConcept(bibliography.getMcdaConcept());
        for (Object element : bibliography.getDescriptionOrBibEntry()) {
            Object _value = element;
            if (_value != null && _value instanceof Description) {
                if (bibEntry.getDescription() == null) {
                    bibEntry.setDescription(new DescriptionConverter().convertTo_v3((Description)_value));
                } else {
                    this.getWarnings().elementIgnored(DESCRIPTION, "Only the first element is taken into account");
                }
            }
            if (_value == null || !(_value instanceof String)) continue;
            bibEntry.getBibEntries().add((String)_value);
        }
        this.getWarnings().popTag();
        return bibEntry;
    }

    public Bibliography convertTo_v2(BibliographyEntry bibliography_v3) {
        if (bibliography_v3 == null) {
            return null;
        }
        this.getWarnings().pushTag(BIBLIOGRAPHY, bibliography_v3.id());
        Bibliography bibliography_v2 = new Bibliography();
        bibliography_v2.setId(bibliography_v3.id());
        bibliography_v2.setName(bibliography_v3.name());
        bibliography_v2.setMcdaConcept(bibliography_v3.mcdaConcept());
        List<Object> list = bibliography_v2.getDescriptionOrBibEntry();
        if (bibliography_v3.getDescription() != null) {
            list.add(new DescriptionConverter().convertTo_v2(bibliography_v3.getDescription()));
        }
        if (bibliography_v3.getBibEntries() != null) {
            for (String bibEntry : bibliography_v3.getBibEntries()) {
                list.add(bibEntry);
            }
        }
        this.getWarnings().popTag();
        return bibliography_v2;
    }
}

