/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.Alternative;
import org.xmcda.CategoriesProfiles;
import org.xmcda.Category;
import org.xmcda.CategoryProfile;
import org.xmcda.Factory;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.ValuesConverter;
import org.xmcda.v2.CategoryProfile;
import org.xmcda.v2.CategoryProfileBound;

public class CategoriesProfilesConverter
extends Converter {
    public static final String CATEGORIES_PROFILES = "categoriesProfiles";
    public static final String CATEGORY_PROFILE = "categoryProfile";

    public CategoriesProfilesConverter() {
        super(CATEGORIES_PROFILES);
    }

    public <T> void convertTo_v3(org.xmcda.v2.CategoriesProfiles value, XMCDA xmcda_v3) {
        CategoryProfile categoryProfile_v3;
        this.getWarnings().pushTag(CATEGORIES_PROFILES, value.getId());
        CategoriesProfiles categoriesProfiles_v3 = Factory.categoriesProfiles();
        categoriesProfiles_v3.setId(value.getId());
        categoriesProfiles_v3.setMcdaConcept(value.getMcdaConcept());
        categoriesProfiles_v3.setName(value.getName());
        categoriesProfiles_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        LinkedHashMap<String, Object[]> map = new LinkedHashMap<String, Object[]>();
        for (org.xmcda.v2.CategoryProfile categoryProfile : value.getCategoryProfile()) {
            CategoryProfile.Limits limits;
            String alternativeID = categoryProfile.getAlternativeID();
            this.getWarnings().pushTag(CATEGORY_PROFILE, "alternativeID: " + alternativeID);
            if (categoryProfile.getId() != null) {
                this.getWarnings().attributeIgnored("id");
            }
            if (categoryProfile.getName() != null) {
                this.getWarnings().attributeIgnored("name");
            }
            if (categoryProfile.getMcdaConcept() != null) {
                this.getWarnings().attributeIgnored("mcdaConcept");
            }
            if (categoryProfile.getDescription() != null) {
                this.getWarnings().elementIgnored("description");
            }
            if ((limits = categoryProfile.getLimits()) != null) {
                CategoryProfileBound[] bounds = new CategoryProfileBound[]{limits.getLowerCategory(), limits.getUpperCategory()};
                for (int i = 0; i < 2; ++i) {
                    if (bounds[i] == null) continue;
                    String cID = bounds[i].getCategoryID();
                    if (!map.containsKey(cID)) {
                        map.put(cID, new Object[]{null, null, null, null});
                    }
                    ((Object[])map.get((Object)cID))[2 * i] = alternativeID;
                    ((Object[])map.get((Object)cID))[2 * i + 1] = bounds[i].getValueOrValues();
                }
            } else {
                CategoryProfile.Central central = categoryProfile.getCentral();
                categoryProfile_v3 = Factory.categoryProfile(CategoryProfile.Type.CENTRAL);
                categoryProfile_v3.setId(categoryProfile.getId());
                categoryProfile_v3.setName(categoryProfile.getName());
                categoryProfile_v3.setMcdaConcept(categoryProfile.getMcdaConcept());
                categoryProfile_v3.setDescription(new DescriptionConverter().convertTo_v3(categoryProfile.getDescription()));
                CategoryProfile.Profile profile_v3 = new CategoryProfile.Profile();
                profile_v3.setAlternative((Alternative)xmcda_v3.alternatives.get(alternativeID));
                profile_v3.setValues(ValuesConverter.valueOrValues_convertTo_v3(central.getValueOrValues(), xmcda_v3, this.getWarnings()));
                categoryProfile_v3.setCategory((Category)xmcda_v3.categories.get(central.getCategoryID()));
                categoryProfile_v3.setCentralProfile(profile_v3);
                categoriesProfiles_v3.add(categoryProfile_v3);
            }
            this.getWarnings().popTag();
        }
        for (String categoryID : map.keySet()) {
            List values_v3;
            CategoryProfile.Profile profile_v3;
            categoryProfile_v3 = Factory.categoryProfile(CategoryProfile.Type.BOUNDING);
            Object[] limit = (Object[])map.get(categoryID);
            categoryProfile_v3.setCategory((Category)xmcda_v3.categories.get(categoryID));
            if (limit[0] != null) {
                profile_v3 = new CategoryProfile.Profile();
                profile_v3.setAlternative((Alternative)xmcda_v3.alternatives.get((String)limit[0]));
                values_v3 = (List)limit[1];
                profile_v3.setValues(ValuesConverter.valueOrValues_convertTo_v3(values_v3, xmcda_v3, this.getWarnings()));
                categoryProfile_v3.setUpperBound(profile_v3);
            }
            if (limit[2] != null) {
                profile_v3 = new CategoryProfile.Profile();
                profile_v3.setAlternative((Alternative)xmcda_v3.alternatives.get((String)limit[2]));
                values_v3 = (List)limit[3];
                profile_v3.setValues(ValuesConverter.valueOrValues_convertTo_v3(values_v3, xmcda_v3, this.getWarnings()));
                categoryProfile_v3.setLowerBound(profile_v3);
            }
            categoriesProfiles_v3.add(categoryProfile_v3);
        }
        xmcda_v3.categoriesProfilesList.add(categoriesProfiles_v3);
        this.getWarnings().popTag();
    }

    public void convertTo_v2(List<CategoriesProfiles<?>> categoriesProfiles_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (CategoriesProfiles<?> categoriesProfiles : categoriesProfiles_v3) {
            org.xmcda.v2.CategoriesProfiles catProfiles_v2 = this.convertTo_v2(categoriesProfiles, xmcda_v2);
            List<JAXBElement<?>> catProfilesList_v2 = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
            catProfilesList_v2.add(new JAXBElement(new QName(CATEGORIES_PROFILES), org.xmcda.v2.CategoriesProfiles.class, (Object)catProfiles_v2));
        }
    }

    protected <T> org.xmcda.v2.CategoriesProfiles convertTo_v2(CategoriesProfiles<T> categoriesProfiles_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag(CATEGORIES_PROFILES, categoriesProfiles_v3.id());
        org.xmcda.v2.CategoriesProfiles categoriesProfiles_v2 = new org.xmcda.v2.CategoriesProfiles();
        categoriesProfiles_v2.setId(categoriesProfiles_v3.id());
        categoriesProfiles_v2.setName(categoriesProfiles_v3.name());
        categoriesProfiles_v2.setMcdaConcept(categoriesProfiles_v3.mcdaConcept());
        categoriesProfiles_v2.setDescription(new DescriptionConverter().convertTo_v2(categoriesProfiles_v3.getDescription()));
        LinkedHashMap<String, Object[]> map = new LinkedHashMap<String, Object[]>();
        for (CategoryProfile categoryProfile : categoriesProfiles_v3) {
            String categoryID = categoryProfile.getCategory().id();
            this.getWarnings().pushTag(CATEGORY_PROFILE, "categoryID: " + categoryID);
            if (categoryProfile.getType() == CategoryProfile.Type.BOUNDING) {
                if (categoryProfile.id() != null) {
                    this.getWarnings().attributeIgnored("id");
                }
                if (categoryProfile.name() != null) {
                    this.getWarnings().attributeIgnored("name");
                }
                if (categoryProfile.mcdaConcept() != null) {
                    this.getWarnings().attributeIgnored("mcdaConcept");
                }
                if (categoryProfile.getDescription() != null) {
                    this.getWarnings().elementIgnored("description");
                }
                CategoryProfile.Profile[] bounds = new CategoryProfile.Profile[]{categoryProfile.getLowerBound(), categoryProfile.getUpperBound()};
                for (int i = 0; i < 2; ++i) {
                    if (bounds[i] == null) continue;
                    String aID = bounds[i].getAlternative().id();
                    if (!map.containsKey(aID)) {
                        map.put(aID, new Object[]{null, null, null, null});
                    }
                    ((Object[])map.get((Object)aID))[2 * i] = categoryID;
                    ((Object[])map.get((Object)aID))[2 * i + 1] = bounds[i].getValues();
                }
            } else {
                org.xmcda.v2.CategoryProfile categoryProfile_v2 = new org.xmcda.v2.CategoryProfile();
                CategoryProfile.Central central = new CategoryProfile.Central();
                central.setCategoryID(categoryID);
                QualifiedValues values = categoryProfile.getCentralProfile().getValues();
                if (values != null) {
                    central.getValueOrValues().add(ValuesConverter.convertTo_v2(values));
                }
                categoryProfile_v2.setCentral(central);
                categoryProfile_v2.setAlternativeID(categoryProfile.getCentralProfile().getAlternative().id());
                categoriesProfiles_v2.getCategoryProfile().add(categoryProfile_v2);
            }
            this.getWarnings().popTag();
        }
        for (String string : map.keySet()) {
            QualifiedValues values;
            CategoryProfileBound bound;
            org.xmcda.v2.CategoryProfile categoryProfile_v2 = new org.xmcda.v2.CategoryProfile();
            CategoryProfile.Limits limits_v2 = new CategoryProfile.Limits();
            categoryProfile_v2.setAlternativeID(string);
            categoryProfile_v2.setLimits(limits_v2);
            Object[] bounds = (Object[])map.get(string);
            if (bounds[0] != null) {
                bound = new CategoryProfileBound();
                bound.setCategoryID((String)bounds[0]);
                values = (QualifiedValues)bounds[1];
                if (values != null) {
                    bound.getValueOrValues().add(ValuesConverter.convertTo_v2(values));
                }
                limits_v2.setUpperCategory(bound);
            }
            if (bounds[2] != null) {
                bound = new CategoryProfileBound();
                bound.setCategoryID((String)bounds[2]);
                values = (QualifiedValues)bounds[3];
                if (values != null) {
                    bound.getValueOrValues().add(ValuesConverter.convertTo_v2(values));
                }
                limits_v2.setLowerCategory(bound);
            }
            categoriesProfiles_v2.getCategoryProfile().add(categoryProfile_v2);
        }
        this.getWarnings().popTag();
        return categoriesProfiles_v2;
    }
}

