/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import org.xmcda.CategoriesValues;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.LabelledQValues;
import org.xmcda.QualifiedValue;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.utils.CommonAttributesUtils;

public class CategoryConverter
extends Converter {
    public static final String CATEGORY = "criterion";
    public static final String ACTIVE = "active";
    public static final String RANK = "rank";

    public CategoryConverter() {
        super(CATEGORY);
    }

    public void convertTo_v3(org.xmcda.v2.Category category_v2, XMCDA xmcda_v3) {
        String id = category_v2.getId();
        this.getWarnings().pushTag(CATEGORY, id);
        Category category_v3 = (Category)xmcda_v3.categories.get(id);
        category_v3.setName(category_v2.getName());
        category_v3.setMcdaConcept(category_v2.getMcdaConcept());
        category_v3.setIsActive(category_v2.isActive() == null ? true : category_v2.isActive());
        category_v3.setDescription(new DescriptionConverter().convertTo_v3(category_v2.getDescription()));
        this.getWarnings().popTag();
    }

    public void convertRanksTo_v3(org.xmcda.v2.Category category_v2, XMCDA xmcda_v3) {
        this.getWarnings().pushTag(CATEGORY, category_v2.getId());
        boolean ranksCreated = false;
        CategoriesValues<Object> ranks = CommonAttributesUtils.getElementWithMcdaConcept(xmcda_v3.categoriesValuesList, RANK);
        if (ranks == null) {
            ranks = Factory.categoriesValues();
            ranks.setMcdaConcept(RANK);
            ranksCreated = true;
        }
        if (category_v2.getRank() != null) {
            Category category = (Category)xmcda_v3.categories.get(category_v2.getId());
            LabelledQValues lqvalues = Factory.labelledQValues();
            lqvalues.add(new QualifiedValueConverter().convertTo_v3(category_v2.getRank(), xmcda_v3));
            ranks.put(category, lqvalues);
        }
        if (ranksCreated && ranks.size() > 0) {
            xmcda_v3.categoriesValuesList.add(ranks);
        }
        this.getWarnings().popTag();
    }

    public org.xmcda.v2.Category convertTo_v2(Category category_v3, XMCDA xmcda_v3) {
        LabelledQValues values;
        this.getWarnings().pushTag(CATEGORY, category_v3.id());
        CategoriesValues<?> ranks = CommonAttributesUtils.getElementWithMcdaConcept(xmcda_v3.categoriesValuesList, RANK);
        org.xmcda.v2.Category category_v2 = new org.xmcda.v2.Category();
        category_v2.setId(category_v3.id());
        category_v2.setName(category_v3.name());
        category_v2.setMcdaConcept(category_v3.mcdaConcept());
        category_v2.setDescription(new DescriptionConverter().convertTo_v2(category_v3.getDescription()));
        category_v2.setActive(category_v3.isActive());
        LabelledQValues labelledQValues = values = ranks != null ? (LabelledQValues)ranks.get(category_v3) : null;
        if (values != null && values.size() == 1) {
            category_v2.setRank(new QualifiedValueConverter().convertTo_v2((QualifiedValue)values.get(0)));
        }
        this.getWarnings().popTag();
        return category_v2;
    }
}

