/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.Factory;
import org.xmcda.Message;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.v2.Description;
import org.xmcda.v2.MethodMessages;

public class MethodMessagesConverter
extends Converter {
    public static final String METHOD_MESSAGES = "methodMessages";
    public static final String PROGRAM_EXECUTION_RESULTS = "programExecutionResult";

    public MethodMessagesConverter() {
        super(METHOD_MESSAGES);
    }

    public void convertTo_v3(MethodMessages msgs_v2, XMCDA xmcda_v3) {
        this.getWarnings().pushTag(METHOD_MESSAGES, msgs_v2.getId());
        ProgramExecutionResult result_v3 = Factory.programExecutionResult();
        result_v3.setId(msgs_v2.getId());
        result_v3.setName(msgs_v2.getMcdaConcept());
        result_v3.setMcdaConcept(msgs_v2.getMcdaConcept());
        result_v3.updateStatus(ProgramExecutionResult.Status.OK);
        for (JAXBElement<?> _obj : msgs_v2.getDescriptionOrErrorMessageOrLogMessage()) {
            if (_obj.getValue() instanceof Description) {
                result_v3.setDescription(new DescriptionConverter().convertTo_v3((Description)_obj.getValue()));
                continue;
            }
            if (!(_obj.getValue() instanceof org.xmcda.v2.Message)) continue;
            String name = _obj.getName().getLocalPart();
            org.xmcda.v2.Message msg_v2 = (org.xmcda.v2.Message)_obj.getValue();
            Message msg_v3 = new Message();
            msg_v3.setId(msg_v2.getId());
            msg_v3.setName(msg_v2.getName());
            msg_v3.setMcdaConcept(msg_v2.getMcdaConcept());
            msg_v3.setDescription(new DescriptionConverter().convertTo_v3(msg_v2.getDescription()));
            msg_v3.setText(msg_v2.getText());
            if ("message".equals(name)) {
                msg_v3.setLevel(Message.Level.INFO);
            } else if ("logMessage".equals(name)) {
                msg_v3.setLevel(Message.Level.DEBUG);
            } else if ("errorMessage".equals(name)) {
                msg_v3.setLevel(Message.Level.ERROR);
                result_v3.updateStatus(ProgramExecutionResult.Status.ERROR);
            }
            result_v3.add(msg_v3);
        }
        this.getWarnings().popTag();
        xmcda_v3.programExecutionResultsList.add(result_v3);
    }

    public void convertProgramExecutionResultsTo_v2(List<ProgramExecutionResult> results_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (ProgramExecutionResult result_v3 : results_v3) {
            this.convertProgramExecutionResultTo_v2(result_v3, xmcda_v2);
        }
    }

    public void convertProgramExecutionResultTo_v2(ProgramExecutionResult result_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag(PROGRAM_EXECUTION_RESULTS);
        MethodMessages msgs_v2 = new MethodMessages();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(METHOD_MESSAGES), MethodMessages.class, (Object)msgs_v2));
        msgs_v2.setId(result_v3.id());
        msgs_v2.setName(result_v3.name());
        msgs_v2.setMcdaConcept(result_v3.mcdaConcept());
        if (result_v3.getDescription() != null) {
            msgs_v2.getDescriptionOrErrorMessageOrLogMessage().add(new JAXBElement(new QName("description"), Description.class, (Object)new DescriptionConverter().convertTo_v2(result_v3.getDescription())));
        }
        for (Message msg_v3 : result_v3) {
            org.xmcda.v2.Message msg_v2 = new org.xmcda.v2.Message();
            msg_v2.setId(msg_v3.id());
            msg_v2.setName(msg_v3.name());
            msg_v2.setMcdaConcept(msg_v3.mcdaConcept());
            msg_v2.setDescription(new DescriptionConverter().convertTo_v2(msg_v3.getDescription()));
            msg_v2.setText(msg_v3.getText());
            String qname = "logMessage";
            if (Message.Level.DEBUG.equals((Object)msg_v3.getLevel())) {
                qname = "logMessage";
            } else if (Message.Level.INFO.equals((Object)msg_v3.getLevel())) {
                qname = "message";
            } else if (Message.Level.ERROR.equals((Object)msg_v3.getLevel())) {
                qname = "errorMessage";
            }
            msgs_v2.getDescriptionOrErrorMessageOrLogMessage().add(new JAXBElement(new QName(qname), org.xmcda.v2.Message.class, (Object)msg_v2));
        }
        this.getWarnings().popTag();
    }
}

