/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.math.BigInteger;
import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.v2.Description;
import org.xmcda.v2.FuzzyLabel;
import org.xmcda.v2.FuzzyNumber;
import org.xmcda.v2.RankedLabel;
import org.xmcda.v2.Value;
import org.xmcda.value.EndPoint;
import org.xmcda.value.Interval;
import org.xmcda.value.NA;
import org.xmcda.value.PiecewiseLinearFunction;
import org.xmcda.value.Point;
import org.xmcda.value.Rational;
import org.xmcda.value.Segment;
import org.xmcda.value.ValuedLabel;

public class QualifiedValueConverter
extends Converter {
    public static final String VALUE = "value";

    public QualifiedValueConverter() {
        super(VALUE);
    }

    public <T> QualifiedValue<T> convertTo_v3(Value value_v2, XMCDA xmcda_v3) {
        this.getWarnings().pushTag(VALUE, value_v2.getId());
        QualifiedValue<Object> qvalue = Factory.qualifiedValue();
        qvalue.setId(value_v2.getId());
        qvalue.setName(value_v2.getName());
        qvalue.setMcdaConcept(value_v2.getMcdaConcept());
        qvalue.setDescription(new DescriptionConverter().convertTo_v3(value_v2.getDescription()));
        if (value_v2.getInteger() != null) {
            qvalue.setValue(value_v2.getInteger());
        } else if (value_v2.getReal() != null) {
            qvalue.setValue(value_v2.getReal());
        } else if (value_v2.getInterval() != null) {
            org.xmcda.v2.Interval iv2 = value_v2.getInterval();
            Interval<T> interval = new Interval<T>();
            this.getWarnings().elementIgnored("interval:description");
            if (iv2.getLowerBound() != null) {
                interval.setLowerBound(this.convertTo_v3(iv2.getLowerBound(), xmcda_v3));
            }
            if (iv2.getUpperBound() != null) {
                interval.setUpperBound(this.convertTo_v3(iv2.getUpperBound(), xmcda_v3));
            }
            interval.setIsLeftClosed(true);
            interval.setIsRightClosed(true);
            qvalue.setValue(interval);
        } else if (value_v2.getRational() != null) {
            Rational rv3 = new Rational();
            rv3.setNumerator(value_v2.getRational().getNumerator());
            rv3.setDenominator(value_v2.getRational().getDenominator());
            qvalue.setValue(rv3);
        } else if (value_v2.getLabel() != null) {
            qvalue.setValue(value_v2.getLabel());
        } else if (value_v2.getRankedLabel() != null) {
            ValuedLabel<Integer> vlabel_v3 = new ValuedLabel<Integer>();
            this.getWarnings().elementIgnored("rankedLabel:description");
            vlabel_v3.setLabel(value_v2.getRankedLabel().getLabel());
            QualifiedValue<Integer> v = Factory.qualifiedValue();
            v.setValue(new Integer(value_v2.getRankedLabel().getRank().intValue()));
            vlabel_v3.setValue(v);
            qvalue.setValue(vlabel_v3);
        } else if (value_v2.isBoolean() != null) {
            qvalue.setValue(value_v2.isBoolean());
        } else if (value_v2.getNA() != null) {
            qvalue.setValue(NA.na);
        } else if (value_v2.getImage() != null) {
            this.getWarnings().elementIgnored("image");
            qvalue = null;
        } else if (value_v2.getImageRef() != null) {
            this.getWarnings().elementIgnored("imageRef");
            qvalue = null;
        } else if (value_v2.getFuzzyLabel() != null) {
            FuzzyLabel fuzzyLabel_v2 = value_v2.getFuzzyLabel();
            ValuedLabel<org.xmcda.value.FuzzyNumber> vlabel_v3 = new ValuedLabel<org.xmcda.value.FuzzyNumber>();
            this.getWarnings().elementIgnored("fuzzyLabel:description", "Concept does not exist in XMCDA v3");
            vlabel_v3.setLabel(value_v2.getFuzzyLabel().getLabel());
            QualifiedValue<org.xmcda.value.FuzzyNumber> v = Factory.qualifiedValue();
            v.setValue(this.convertFuzzyNumberTo_v3(fuzzyLabel_v2.getFuzzyNumber(), xmcda_v3));
            vlabel_v3.setValue(v);
            qvalue.setValue(vlabel_v3);
        } else if (value_v2.getFuzzyNumber() != null) {
            FuzzyNumber fuzzyNumber_v2 = value_v2.getFuzzyNumber();
            org.xmcda.value.FuzzyNumber fuzzyNumber_v3 = this.convertFuzzyNumberTo_v3(fuzzyNumber_v2, xmcda_v3);
            qvalue.setValue(fuzzyNumber_v3);
        }
        this.getWarnings().popTag();
        return qvalue;
    }

    public Segment convertSegmentTo_v3(org.xmcda.v2.Point p1, org.xmcda.v2.Point p2, XMCDA xmcda_v3) {
        Segment segment_v3 = new Segment();
        Point p1_v3 = new Point();
        Point p2_v3 = new Point();
        p1_v3.setAbscissa(this.convertTo_v3(p1.getAbscissa(), xmcda_v3));
        p1_v3.setOrdinate(this.convertTo_v3(p1.getOrdinate(), xmcda_v3));
        p2_v3.setAbscissa(this.convertTo_v3(p2.getAbscissa(), xmcda_v3));
        p2_v3.setOrdinate(this.convertTo_v3(p2.getOrdinate(), xmcda_v3));
        segment_v3.setHead(new EndPoint(p1_v3));
        segment_v3.setTail(new EndPoint(p2_v3));
        return segment_v3;
    }

    public org.xmcda.value.FuzzyNumber convertFuzzyNumberTo_v3(FuzzyNumber fuzzyNumber_v2, XMCDA xmcda_v3) {
        org.xmcda.value.FuzzyNumber fuzzyNumber_v3 = new org.xmcda.value.FuzzyNumber();
        Description desc_v2 = fuzzyNumber_v2.getDescription();
        if (desc_v2 != null) {
            this.getWarnings().elementIgnored("fuzzyNumber/description", "Concept does not exist in XMCDA v3");
        }
        PiecewiseLinearFunction function_v3 = new PiecewiseLinearFunction();
        if (fuzzyNumber_v2.getTrapezoidal() != null) {
            FuzzyNumber.Trapezoidal tv2 = fuzzyNumber_v2.getTrapezoidal();
            function_v3.add(this.convertSegmentTo_v3(tv2.getPoint1(), tv2.getPoint2(), xmcda_v3));
            function_v3.add(this.convertSegmentTo_v3(tv2.getPoint2(), tv2.getPoint3(), xmcda_v3));
            function_v3.add(this.convertSegmentTo_v3(tv2.getPoint3(), tv2.getPoint4(), xmcda_v3));
            fuzzyNumber_v3.setFunction(function_v3);
        } else if (fuzzyNumber_v2.getTriangular() != null) {
            FuzzyNumber.Triangular tv2 = fuzzyNumber_v2.getTriangular();
            function_v3.add(this.convertSegmentTo_v3(tv2.getPoint1(), tv2.getPoint2(), xmcda_v3));
            function_v3.add(this.convertSegmentTo_v3(tv2.getPoint2(), tv2.getPoint3(), xmcda_v3));
            fuzzyNumber_v3.setFunction(function_v3);
        }
        return fuzzyNumber_v3;
    }

    public Value convertTo_v2(QualifiedValue<?> value_v3) {
        this.getWarnings().pushTag(VALUE, value_v3.id());
        Value value_v2 = new Value();
        value_v2.setId(value_v3.id());
        value_v2.setName(value_v3.name());
        value_v2.setMcdaConcept(value_v3.mcdaConcept());
        value_v2.setDescription(new DescriptionConverter().convertTo_v2(value_v3.getDescription()));
        Object value = value_v3.getValue();
        if (value instanceof Integer) {
            value_v2.setInteger((Integer)value);
        } else if (value instanceof Double) {
            value_v2.setReal((Double)value);
        } else if (value instanceof Float) {
            value_v2.setReal(((Float)value).doubleValue());
        } else if (value instanceof Interval) {
            Interval iv3 = (Interval)value;
            org.xmcda.v2.Interval iv2 = new org.xmcda.v2.Interval();
            if (iv3.getLowerBound() != null) {
                iv2.setLowerBound(this.convertTo_v2(iv3.getLowerBound()));
            }
            if (iv3.getUpperBound() != null) {
                iv2.setUpperBound(this.convertTo_v2(iv3.getUpperBound()));
            }
            if (!iv3.isLeftClosed()) {
                this.getWarnings().elementIgnored("interval/leftclosed", "Concept does not exist in XMCDA v2");
            }
            if (!iv3.isRightClosed()) {
                this.getWarnings().elementIgnored("interval/rightClosed", "Concept does not exist in XMCDA v2");
            }
            value_v2.setInterval(iv2);
        } else if (value instanceof Rational) {
            Rational rv3 = (Rational)value;
            org.xmcda.v2.Rational rv2 = new org.xmcda.v2.Rational();
            rv2.setNumerator(rv3.getNumerator());
            rv2.setDenominator(rv3.getDenominator());
            value_v2.setRational(rv2);
        } else if (value instanceof String) {
            value_v2.setLabel((String)value);
        } else if (value instanceof Boolean) {
            value_v2.setBoolean((Boolean)value);
        } else if (value instanceof NA) {
            value_v2.setNA("");
        } else if (value instanceof org.xmcda.value.FuzzyNumber) {
            value_v2.setFuzzyNumber(this.convertFuzzyNumberTo_v2((org.xmcda.value.FuzzyNumber)value));
        } else if (value instanceof ValuedLabel) {
            ValuedLabel vl_v3 = (ValuedLabel)value;
            if (vl_v3.getValue().getValue() instanceof Integer) {
                RankedLabel rl_v2 = new RankedLabel();
                rl_v2.setLabel(vl_v3.getLabel());
                rl_v2.setRank(new BigInteger(vl_v3.getValue().getValue().toString()));
                value_v2.setRankedLabel(rl_v2);
            } else if (vl_v3.getValue().getValue() instanceof org.xmcda.value.FuzzyNumber) {
                FuzzyLabel fl_v2 = new FuzzyLabel();
                fl_v2.setLabel(vl_v3.getLabel());
                fl_v2.setFuzzyNumber(this.convertFuzzyNumberTo_v2((org.xmcda.value.FuzzyNumber)vl_v3.getValue().getValue()));
                value_v2.setFuzzyLabel(fl_v2);
            } else {
                this.getWarnings().elementIgnored("valuedLabel w/ type:" + vl_v3.getValue().getValue().getClass(), "Concept does not exist in XMCDA v2");
            }
        }
        this.getWarnings().popTag();
        return value_v2;
    }

    public FuzzyNumber convertFuzzyNumberTo_v2(org.xmcda.value.FuzzyNumber fuzzyNumber_v3) {
        FuzzyNumber fuzzy_v2 = new FuzzyNumber();
        if (!(fuzzyNumber_v3.getFunction() instanceof PiecewiseLinearFunction)) {
            this.getWarnings().elementIgnored("fuzzyNumber: not piecewise", "Concept does not exist in XMCDA v2");
            return fuzzy_v2;
        }
        PiecewiseLinearFunction pl_v3 = (PiecewiseLinearFunction)fuzzyNumber_v3.getFunction();
        if (pl_v3.size() == 3) {
            FuzzyNumber.Trapezoidal trapezoidal = new FuzzyNumber.Trapezoidal();
            trapezoidal.setPoint1(this.convertPointTo_v2(((Segment)pl_v3.get(0)).getHead()));
            trapezoidal.setPoint2(this.convertPointTo_v2(((Segment)pl_v3.get(0)).getTail()));
            trapezoidal.setPoint3(this.convertPointTo_v2(((Segment)pl_v3.get(1)).getTail()));
            trapezoidal.setPoint4(this.convertPointTo_v2(((Segment)pl_v3.get(2)).getTail()));
            fuzzy_v2.setTrapezoidal(trapezoidal);
        } else if (pl_v3.size() == 2) {
            FuzzyNumber.Triangular triangle = new FuzzyNumber.Triangular();
            triangle.setPoint1(this.convertPointTo_v2(((Segment)pl_v3.get(0)).getHead()));
            triangle.setPoint2(this.convertPointTo_v2(((Segment)pl_v3.get(0)).getTail()));
            triangle.setPoint3(this.convertPointTo_v2(((Segment)pl_v3.get(1)).getTail()));
            fuzzy_v2.setTriangular(triangle);
        } else {
            if (pl_v3.size() < 2) {
                this.getWarnings().elementIgnored("fuzzyNumber: less than 2 segments", "Concept does not exist in XMCDA v2");
                return fuzzy_v2;
            }
            if (pl_v3.size() > 3) {
                this.getWarnings().elementIgnored("fuzzyNumber: more than 3 segments", "Concept does not exist in XMCDA v2");
                return fuzzy_v2;
            }
        }
        return fuzzy_v2;
    }

    protected org.xmcda.v2.Point convertPointTo_v2(EndPoint point_v3) {
        org.xmcda.v2.Point point_v2 = new org.xmcda.v2.Point();
        point_v2.setAbscissa(this.convertTo_v2(point_v3.getAbscissa()));
        point_v2.setOrdinate(this.convertTo_v2(point_v3.getOrdinate()));
        return point_v2;
    }
}

