/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xmcda.parsers.xml.xmcda_v2.XMCDA_v2_VERSION;
import org.xmcda.parsers.xml.xmcda_v2.XMCDAv2OutputStream;
import org.xmcda.v2.XMCDA;
import org.xml.sax.SAXException;

public class XMCDAParser {
    public static XMCDA readXMCDA(String filename) throws IOException, JAXBException, SAXException {
        return XMCDAParser.readXMCDA(new File(filename), new String[0]);
    }

    public static XMCDA readXMCDA(String filename, String ... tagsOnly) throws IOException, JAXBException, SAXException {
        return XMCDAParser.readXMCDA(new File(filename), tagsOnly);
    }

    public static XMCDA readXMCDA(File file) throws JAXBException, IOException, SAXException {
        return XMCDAParser.readXMCDA(file, new String[0]);
    }

    private static boolean isTagInList(String xmlTag, String[] tagsList) throws NullPointerException {
        if (xmlTag == null) {
            throw new NullPointerException("xmlTag cannot be null");
        }
        if (tagsList == null || tagsList.length == 0) {
            return false;
        }
        for (String tagOnly : tagsList) {
            if (tagOnly == null) {
                throw new NullPointerException("tagsOnly cannot contain null values");
            }
            if (!xmlTag.equals(tagOnly)) continue;
            return true;
        }
        return false;
    }

    private static void filterXMCDA(XMCDA xmcda, String ... tagsOnly) {
        if (tagsOnly == null || tagsOnly.length == 0) {
            return;
        }
        ArrayList xmcda_copy = new ArrayList(xmcda.getProjectReferenceOrMethodMessagesOrMethodParameters());
        for (JAXBElement<?> tag : xmcda_copy) {
            String tagName = tag.getName().getLocalPart();
            if (XMCDAParser.isTagInList(tagName, tagsOnly)) continue;
            xmcda.getProjectReferenceOrMethodMessagesOrMethodParameters().remove(tag);
        }
    }

    public static XMCDA readXMCDA(File file, String ... tagsOnly) throws IOException, JAXBException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] source = new Source[]{new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_v2_VERSION.get((String)"2.0.0").local_xsd_location)), new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_v2_VERSION.get((String)"2.1.0").local_xsd_location)), new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_v2_VERSION.get((String)"2.2.0").local_xsd_location)), new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_v2_VERSION.get((String)"2.2.1").local_xsd_location)), new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_v2_VERSION.get((String)"2.2.2").local_xsd_location))};
        Schema schema = schemaFactory.newSchema(source);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new FileInputStream(file)));
        }
        catch (SAXException exc) {
            throw new SAXException("Validation failed", exc);
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XMCDA.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        XMCDA xmcda = (XMCDA)unmarshaller.unmarshal((Source)new StreamSource(file), XMCDA.class).getValue();
        XMCDAParser.filterXMCDA(xmcda, tagsOnly);
        return xmcda;
    }

    public static void writeXMCDA(XMCDA xmcda, String filename) throws JAXBException {
        XMCDAParser.writeXMCDA(xmcda, new File(filename), new String[0]);
    }

    public static void writeXMCDA(XMCDA xmcda, String filename, String ... tagsOnly) throws JAXBException {
        XMCDAParser.writeXMCDA(xmcda, new File(filename), tagsOnly);
    }

    public static void writeXMCDA(XMCDA xmcda, File file) throws JAXBException {
        XMCDAParser.writeXMCDA(xmcda, file, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMCDA(XMCDA xmcda, File file, String ... tagsOnly) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XMCDA.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ArrayList xmcda_copy = new ArrayList(xmcda.getProjectReferenceOrMethodMessagesOrMethodParameters());
        try {
            XMCDAParser.filterXMCDA(xmcda, tagsOnly);
            XMCDAv2OutputStream xmcda2outs = new XMCDAv2OutputStream(new FileOutputStream(file));
            marshaller.marshal((Object)xmcda, (OutputStream)xmcda2outs);
            xmcda2outs.close();
        }
        catch (IOException jexc) {
            jexc.printStackTrace();
        }
        finally {
            xmcda.getProjectReferenceOrMethodMessagesOrMethodParameters().clear();
            xmcda.getProjectReferenceOrMethodMessagesOrMethodParameters().addAll(xmcda_copy);
        }
    }

    public static void main(String[] args) throws Exception {
        XMCDAParser.readXMCDA("alternatives.xml");
    }
}

