/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.CommonAttributes;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.ReferenceableParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class AlternativeParser {
    public static final String ALTERNATIVE = "alternative";
    public static final String TYPE = "type";
    public static final String ACTIVE = "active";

    public Alternative fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CommonAttributes attributeHolder = new ReferenceableParser().getAttributes(startElement);
        Alternative alternative = (Alternative)xmcda.alternatives.get(attributeHolder.id());
        alternative.setName(attributeHolder.name());
        alternative.setMcdaConcept(attributeHolder.mcdaConcept());
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVE.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                alternative.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (TYPE.equals(startElement.getName().getLocalPart())) {
                event = eventReader.nextEvent();
                String type = event.asCharacters().getData();
                alternative.setIsReal("real".equals(type));
                continue;
            }
            if (!ACTIVE.equals(startElement.getName().getLocalPart())) continue;
            event = eventReader.nextEvent();
            String active = event.asCharacters().getData();
            alternative.setIsActive("true".equals(active) || "1".equals(active));
        }
        return alternative;
    }

    public void toXML(Alternative alternative, XMLStreamWriter writer) throws XMLStreamException {
        if (alternative == null) {
            return;
        }
        writer.writeStartElement(ALTERNATIVE);
        new ReferenceableParser().toXML(alternative, writer);
        writer.writeln();
        new DescriptionParser().toXML(alternative.getDescription(), writer);
        writer.writeElementChars(TYPE, alternative.isReal() ? "real" : "fictive");
        writer.writeElementBoolean(ACTIVE, alternative.isActive());
        writer.writeEndElement();
        writer.writeln();
    }
}

