/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.AlternativesLinearConstraints;
import org.xmcda.Factory;
import org.xmcda.LinearConstraint;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.LinearConstraintParser;
import org.xmcda.parsers.xml.xmcda_v3.VariablesParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class AlternativesLinearConstraintsParser<VALUE_TYPE> {
    public static final String ALTERNATIVES_LINEAR_CONSTRAINTS = "alternativesLinearConstraints";
    public static final String ALTERNATIVE_ID = "alternativeID";

    public LinearConstraintParser.LinearConstraintParserHelper<Alternative> helper() {
        return new Helper();
    }

    public AlternativesLinearConstraints<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        AlternativesLinearConstraints constraints = Factory.alternativesLinearConstraints();
        new CommonAttributesParser().handleAttributes(constraints, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVES_LINEAR_CONSTRAINTS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                constraints.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("variables".equals(startElement.getName().getLocalPart())) {
                constraints.setVariables(new VariablesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"constraints".equals(startElement.getName().getLocalPart())) continue;
            this.readConstraintsFromXML(xmcda, constraints, startElement, eventReader);
        }
        return constraints;
    }

    public void readConstraintsFromXML(XMCDA xmcda, AlternativesLinearConstraints<VALUE_TYPE> constraints, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && "constraints".equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !"constraint".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            constraints.add(new LinearConstraintParser().constraintFromXML(xmcda, this.helper(), startElement, eventReader));
        }
    }

    public void toXML(List<AlternativesLinearConstraints<VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (AlternativesLinearConstraints<VALUE_TYPE> constraints : list) {
            this.toXML(constraints, writer);
        }
    }

    public void toXML(AlternativesLinearConstraints<VALUE_TYPE> constraints, XMLStreamWriter writer) throws XMLStreamException {
        if (constraints == null) {
            return;
        }
        writer.writeStartElement(ALTERNATIVES_LINEAR_CONSTRAINTS);
        new CommonAttributesParser().toXML(constraints, writer);
        writer.writeln();
        new DescriptionParser().toXML(constraints.getDescription(), writer);
        new VariablesParser().toXML(constraints.getVariables(), writer);
        writer.writeStartElement("constraints");
        writer.writeln();
        for (LinearConstraint linearConstraint : constraints) {
            new LinearConstraintParser().toXML(ALTERNATIVE_ID, linearConstraint, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }

    private class Helper
    extends LinearConstraintParser.LinearConstraintParserHelper<Alternative> {
        private Helper() {
        }

        @Override
        public Alternative buildObject(XMCDA xmcda, String id) {
            return (Alternative)xmcda.alternatives.get(id);
        }
    }
}

