/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Category;
import org.xmcda.CommonAttributes;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.ReferenceableParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CategoryParser {
    public static final String CATEGORY = "category";
    public static final String ACTIVE = "active";

    public Category fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CommonAttributes attribueHolder = new ReferenceableParser().getAttributes(startElement);
        Category category = (Category)xmcda.categories.get(attribueHolder.id());
        category.setName(attribueHolder.name());
        category.setMcdaConcept(attribueHolder.mcdaConcept());
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CATEGORY.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                category.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!ACTIVE.equals(startElement.getName().getLocalPart())) continue;
            event = eventReader.nextEvent();
            String active = event.asCharacters().getData();
            category.setIsActive("true".equals(active) || "1".equals(active));
        }
        return category;
    }

    public void toXML(Category category, XMLStreamWriter writer) throws XMLStreamException {
        if (category == null) {
            return;
        }
        writer.writeStartElement(CATEGORY);
        new ReferenceableParser().toXML(category, writer);
        writer.writeln();
        new DescriptionParser().toXML(category.getDescription(), writer);
        writer.writeElementBoolean(ACTIVE, category.isActive());
        writer.writeEndElement();
        writer.writeln();
    }
}

