/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.Category;
import org.xmcda.CategoryProfile;
import org.xmcda.Description;
import org.xmcda.Factory;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CategoryProfileParser<VALUE_TYPE> {
    public static final String CATEGORY_PROFILE = "categoryProfile";
    public static final String CATEGORY_ID = "categoryID";
    public static final String CENTRAL = "central";
    public static final String BOUNDING = "bounding";
    public static final String ALTERNATIVE_ID = "alternativeID";
    public static final String LOWER_BOUND = "lowerBound";
    public static final String UPPER_BOUND = "upperBound";

    public CategoryProfile<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        StartElement initialElement = startElement;
        String initialTag = initialElement.getName().getLocalPart();
        CategoryProfile<VALUE_TYPE> profile = null;
        Category category = null;
        Description description = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.asStartElement().getName().getLocalPart();
            if ("description".equals(currentTagName)) {
                description = new DescriptionParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (CATEGORY_ID.equals(currentTagName)) {
                category = (Category)xmcda.categories.get(Utils.getTextContent(startElement, eventReader));
                continue;
            }
            if (CENTRAL.equals(currentTagName)) {
                profile = Factory.categoryProfile(CategoryProfile.Type.CENTRAL);
                profile.setCentralProfile(this.profileFromXML(xmcda, CENTRAL, eventReader));
                continue;
            }
            if (!BOUNDING.equals(currentTagName)) continue;
            profile = this.boundingProfileFromXML(xmcda, startElement, eventReader);
        }
        new CommonAttributesParser().handleAttributes(profile, initialElement);
        profile.setCategory(category);
        profile.setDescription(description);
        return profile;
    }

    public CategoryProfile<VALUE_TYPE> boundingProfileFromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CategoryProfile<VALUE_TYPE> boundingProfile = Factory.categoryProfile(CategoryProfile.Type.BOUNDING);
        StartElement initialElement = startElement;
        String initialTag = initialElement.getName().getLocalPart();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.asStartElement().getName().getLocalPart();
            if (LOWER_BOUND.equals(currentTagName)) {
                boundingProfile.setLowerBound(this.profileFromXML(xmcda, LOWER_BOUND, eventReader));
                continue;
            }
            if (!UPPER_BOUND.equals(currentTagName)) continue;
            boundingProfile.setUpperBound(this.profileFromXML(xmcda, UPPER_BOUND, eventReader));
        }
        return boundingProfile;
    }

    public CategoryProfile.Profile<VALUE_TYPE> profileFromXML(XMCDA xmcda, String initialTag, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CategoryProfile.Profile profile = new CategoryProfile.Profile();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            if (ALTERNATIVE_ID.equals(startElement.asStartElement().getName().getLocalPart())) {
                profile.setAlternative((Alternative)xmcda.alternatives.get(Utils.getTextContent(startElement, eventReader)));
                continue;
            }
            if (!"values".equals(startElement.asStartElement().getName().getLocalPart())) continue;
            profile.setValues(new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader));
        }
        return profile;
    }

    public void toXML(CategoryProfile<VALUE_TYPE> categoryProfile, XMLStreamWriter writer) throws XMLStreamException {
        if (categoryProfile == null) {
            return;
        }
        writer.writeStartElement(CATEGORY_PROFILE);
        new CommonAttributesParser().toXML(categoryProfile, writer);
        writer.writeln();
        new DescriptionParser().toXML(categoryProfile.getDescription(), writer);
        writer.writeElementChars(CATEGORY_ID, categoryProfile.getCategory().id());
        if (categoryProfile.getType().equals((Object)CategoryProfile.Type.CENTRAL)) {
            this.profileToXML(CENTRAL, categoryProfile.getCentralProfile(), writer);
        } else {
            writer.writeStartElement(BOUNDING);
            writer.writeln();
            this.profileToXML(LOWER_BOUND, categoryProfile.getLowerBound(), writer);
            this.profileToXML(UPPER_BOUND, categoryProfile.getUpperBound(), writer);
            writer.writeEndElement();
            writer.writeln();
        }
        writer.writeEndElement();
        writer.writeln();
    }

    public void profileToXML(String tag, CategoryProfile.Profile<VALUE_TYPE> profile, XMLStreamWriter writer) throws XMLStreamException {
        if (profile == null) {
            return;
        }
        writer.writeStartElement(tag);
        writer.writeln();
        writer.writeElementChars(ALTERNATIVE_ID, profile.getAlternative().id());
        new QualifiedValuesParser<VALUE_TYPE>().toXML(profile.getValues(), writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

