/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CategoriesValues;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.LabelledQValues;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CategoryValuesParser<VALUE_TYPE> {
    public static final String CATEGORY_VALUE = "categoryValue";
    public static final String CATEGORY_ID = "categoryID";

    public Category fromXML(XMCDA xmcda, CategoriesValues<VALUE_TYPE> objectsValues, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        LabelledQValues categoryValues = Factory.labelledQValues();
        new CommonAttributesParser().handleAttributes(categoryValues, startElement);
        Category category = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CATEGORY_VALUE.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                categoryValues.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("values".equals(startElement.asStartElement().getName().getLocalPart())) {
                categoryValues.addAll(new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!CATEGORY_ID.equals(startElement.getName().getLocalPart())) continue;
            String id = Utils.getTextContent(startElement, eventReader);
            category = (Category)xmcda.categories.get(id);
        }
        objectsValues.put(category, categoryValues);
        return category;
    }

    public void toXML(Category category, LabelledQValues<VALUE_TYPE> categoryValues, XMLStreamWriter writer) throws XMLStreamException {
        if (categoryValues == null) {
            return;
        }
        writer.writeStartElement(CATEGORY_VALUE);
        new CommonAttributesParser().toXML(categoryValues, writer);
        writer.writeln();
        new DescriptionParser().toXML(categoryValues.getDescription(), writer);
        writer.writeElementChars(CATEGORY_ID, category.id());
        new QualifiedValuesParser<VALUE_TYPE>().toXML(categoryValues, writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

