/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CriteriaThresholds;
import org.xmcda.Criterion;
import org.xmcda.CriterionThresholds;
import org.xmcda.Factory;
import org.xmcda.Threshold;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.ThresholdParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CriterionThresholdsParser {
    public static final String CRITERION_THRESHOLD = "criterionThreshold";
    public static final String CRITERION_ID = "criterionID";
    public static final String THRESHOLDS = "thresholds";

    public Criterion fromXML(XMCDA xmcda, CriteriaThresholds criteriaThresholds, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CriterionThresholds thresholds = Factory.criterionThresholds();
        new CommonAttributesParser().handleAttributes(thresholds, startElement);
        Criterion criterion = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CRITERION_THRESHOLD.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                thresholds.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (CRITERION_ID.equals(startElement.getName().getLocalPart())) {
                criterion = (Criterion)xmcda.criteria.get(Utils.getTextContent(startElement, eventReader));
            }
            if (!THRESHOLDS.equals(startElement.getName().getLocalPart())) continue;
            this.thresholdsFromXML(xmcda, thresholds, startElement, eventReader);
        }
        criteriaThresholds.put(criterion, thresholds);
        return criterion;
    }

    public void thresholdsFromXML(XMCDA xmcda, CriterionThresholds criterionThresholds, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && THRESHOLDS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !"threshold".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            criterionThresholds.add(new ThresholdParser().fromXML(xmcda, startElement, eventReader));
        }
    }

    public void toXML(Criterion criterion, CriterionThresholds criterionThresholds, XMLStreamWriter writer) throws XMLStreamException {
        if (criterionThresholds == null) {
            return;
        }
        writer.writeStartElement(CRITERION_THRESHOLD);
        new CommonAttributesParser().toXML(criterionThresholds, writer);
        writer.writeln();
        new DescriptionParser().toXML(criterionThresholds.getDescription(), writer);
        writer.writeElementChars(CRITERION_ID, criterion.id());
        writer.writeStartElement(THRESHOLDS);
        writer.writeln();
        for (Threshold threshold : criterionThresholds) {
            new ThresholdParser().toXML(threshold, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }
}

