/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.BibliographyEntry;
import org.xmcda.Description;
import org.xmcda.Factory;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class DescriptionParser {
    public static final String DESCRIPTION = "description";
    public static final String AUTHOR = "author";
    public static final String COMMENT = "comment";
    public static final String KEYWORD = "keyword";
    public static final String BIBLIOGRAPHY = "bibliography";
    public static final String CREATION_DATE = "creationDate";
    public static final String LAST_MODIFICATION_DATE = "lastModificationDate";
    public static final String BIB_ENTRY = "bibEntry";

    public Description fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        Description description = Factory.description();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && DESCRIPTION.equals(event.asEndElement().getName().getLocalPart()))) {
            DatatypeFactory dtf;
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (BIBLIOGRAPHY.equals(startElement.getName().getLocalPart())) {
                description.setBibliography(this.handleBibliography(xmcda, startElement, eventReader));
            }
            event = eventReader.nextEvent();
            String content = "";
            if (event.isCharacters()) {
                content = event.asCharacters().getData();
            }
            if (AUTHOR.equals(startElement.getName().getLocalPart())) {
                description.getAuthors().add(content);
                continue;
            }
            if (COMMENT.equals(startElement.getName().getLocalPart())) {
                description.setComment(content);
                continue;
            }
            if (KEYWORD.equals(startElement.getName().getLocalPart())) {
                description.getKeywords().add(content);
                continue;
            }
            if (CREATION_DATE.equals(startElement.getName().getLocalPart())) {
                try {
                    dtf = DatatypeFactory.newInstance();
                    description.setCreationDate(dtf.newXMLGregorianCalendar(content).toGregorianCalendar());
                }
                catch (DatatypeConfigurationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!LAST_MODIFICATION_DATE.equals(startElement.getName().getLocalPart())) continue;
            try {
                dtf = DatatypeFactory.newInstance();
                description.setLastModificationDate(dtf.newXMLGregorianCalendar(content).toGregorianCalendar());
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        return description;
    }

    public BibliographyEntry handleBibliography(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        BibliographyEntry bibliographyEntry = Factory.bibliographyEntry();
        new CommonAttributesParser().handleAttributes(bibliographyEntry, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && BIBLIOGRAPHY.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            if (DESCRIPTION.equals(event.asStartElement().getName().getLocalPart())) {
                bibliographyEntry.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!BIB_ENTRY.equals(event.asStartElement().getName().getLocalPart())) continue;
            event = eventReader.nextEvent();
            String content = "";
            if (event.isCharacters()) {
                content = event.asCharacters().getData();
            }
            bibliographyEntry.getBibEntries().add(content);
        }
        return bibliographyEntry;
    }

    public void toXML(Description description, XMLStreamWriter writer) throws XMLStreamException {
        XMLGregorianCalendar xml_date;
        DatatypeFactory dtf;
        if (description == null) {
            return;
        }
        writer.writeStartElement(DESCRIPTION);
        writer.writeln();
        for (String author : description.getAuthors()) {
            writer.writeElementChars(AUTHOR, author);
        }
        if (description.getComment() != null) {
            writer.writeElementChars(COMMENT, description.getComment());
        }
        for (String keyword : description.getKeywords()) {
            writer.writeElementChars(KEYWORD, keyword);
        }
        this.toXML(description.getBibliography(), writer);
        if (description.getCreationDate() != null) {
            try {
                dtf = DatatypeFactory.newInstance();
                xml_date = dtf.newXMLGregorianCalendar(description.getCreationDate());
                writer.writeElementChars(CREATION_DATE, xml_date.toXMLFormat());
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        if (description.getLastModificationDate() != null) {
            try {
                dtf = DatatypeFactory.newInstance();
                xml_date = dtf.newXMLGregorianCalendar(description.getLastModificationDate());
                writer.writeElementChars(LAST_MODIFICATION_DATE, xml_date.toXMLFormat());
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        writer.writeEndElement();
        writer.writeln();
    }

    public void toXML(BibliographyEntry bibliography, XMLStreamWriter writer) throws XMLStreamException {
        if (bibliography == null) {
            return;
        }
        writer.writeStartElement(BIBLIOGRAPHY);
        new CommonAttributesParser().toXML(bibliography, writer);
        writer.writeln();
        this.toXML(bibliography.getDescription(), writer);
        for (String bibEntry : bibliography.getBibEntries()) {
            writer.writeElementChars(BIB_ENTRY, bibEntry);
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

