/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.PointParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.ValueParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.EndPoint;

public class EndPointParser {
    public static final String OPEN = "open";

    public EndPoint fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        StartElement head_element = startElement;
        EndPoint endPoint = new EndPoint(new PointParser().fromXML(xmcda, startElement, eventReader));
        Attribute open = head_element.getAttributeByName(new QName(OPEN));
        if (open != null) {
            endPoint.setOpen(Utils.booleanValue(open.getValue()));
        }
        return endPoint;
    }

    public void toXML(String startTag, EndPoint endPoint, XMLStreamWriter writer) throws XMLStreamException {
        if (endPoint == null) {
            return;
        }
        writer.writeStartElement(startTag);
        writer.writeAttribute(OPEN, endPoint.isOpen() ? "true" : "false");
        writer.writeln();
        writer.writeStartElement("abscissa");
        writer.writeln();
        new ValueParser().toXML(endPoint.getAbscissa().getValue(), writer);
        writer.writeEndElement();
        writer.writeln();
        writer.writeStartElement("ordinate");
        writer.writeln();
        new ValueParser().toXML(endPoint.getOrdinate().getValue(), writer);
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }
}

