/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.AffineFunctionParser;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.ConstantFunctionParser;
import org.xmcda.parsers.xml.xmcda_v3.DiscreteFunctionParser;
import org.xmcda.parsers.xml.xmcda_v3.PiecewiseLinearFunctionParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.AffineFunction;
import org.xmcda.value.ConstantFunction;
import org.xmcda.value.DiscreteFunction;
import org.xmcda.value.Function;
import org.xmcda.value.PiecewiseLinearFunction;

public class FunctionParser {
    public static final String FUNCTION = "function";

    public Function fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        Function function = null;
        StartElement initialElement = startElement;
        String initialTag = initialElement.getName().getLocalPart();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if ("constant".equals(currentTagName)) {
                function = new ConstantFunctionParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if ("affine".equals(currentTagName)) {
                function = new AffineFunctionParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if ("piecewiseLinear".equals(currentTagName)) {
                function = new PiecewiseLinearFunctionParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (!"discrete".equals(currentTagName)) continue;
            function = new DiscreteFunctionParser().fromXML(xmcda, startElement, eventReader);
        }
        new CommonAttributesParser().handleAttributes(function, initialElement);
        return function;
    }

    public void toXML(String tag, Function function, XMLStreamWriter writer) throws XMLStreamException {
        if (function == null) {
            return;
        }
        writer.writeStartElement(tag);
        new CommonAttributesParser().toXML(function, writer);
        writer.writeln();
        if (function instanceof ConstantFunction) {
            new ConstantFunctionParser().toXML((ConstantFunction)function, writer);
        } else if (function instanceof AffineFunction) {
            new AffineFunctionParser().toXML((AffineFunction)function, writer);
        } else if (function instanceof PiecewiseLinearFunction) {
            new PiecewiseLinearFunctionParser().toXML((PiecewiseLinearFunction)function, writer);
        } else if (function instanceof DiscreteFunction) {
            new DiscreteFunctionParser().toXML((DiscreteFunction)function, writer);
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

