/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CommonAttributes;
import org.xmcda.Factory;
import org.xmcda.LinearConstraint;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValueParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class LinearConstraintParser<ELEMENT extends CommonAttributes, VALUE_TYPE> {
    public static final String CONSTRAINTS = "constraints";
    public static final String CONSTRAINT = "constraint";
    public static final String ELEMENTS = "elements";
    public static final String ELEMENT = "element";
    public static final String OPERATOR = "operator";
    public static final String RHS = "rhs";
    public static final String VALUES = "values";
    public static final String VARIABLE_ID = "variableID";
    public static final String COEFFICIENT = "coefficient";

    protected LinearConstraint<ELEMENT, VALUE_TYPE> constraintFromXML(XMCDA xmcda, LinearConstraintParserHelper<ELEMENT> helper, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        LinearConstraint constraint = Factory.linearConstraint();
        new CommonAttributesParser().handleAttributes(constraint, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CONSTRAINT.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                constraint.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (ELEMENTS.equals(startElement.getName().getLocalPart())) {
                constraint.setElements(this.elementsFromXML(xmcda, helper, startElement, eventReader));
                continue;
            }
            if (OPERATOR.equals(startElement.getName().getLocalPart())) {
                constraint.setOperator(LinearConstraint.Operator.valueOf(Utils.getTextContent(startElement, eventReader).toUpperCase()));
                continue;
            }
            if (RHS.equals(startElement.getName().getLocalPart())) {
                constraint.setRhs(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!VALUES.equals(startElement.getName().getLocalPart())) continue;
            constraint.setValues(new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader));
        }
        return constraint;
    }

    private ArrayList<LinearConstraint.Element<ELEMENT, VALUE_TYPE>> elementsFromXML(XMCDA xmcda, LinearConstraintParserHelper<ELEMENT> helper, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        ArrayList<LinearConstraint.Element<ELEMENT, VALUE_TYPE>> elements = new ArrayList<LinearConstraint.Element<ELEMENT, VALUE_TYPE>>();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ELEMENTS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !ELEMENT.equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            elements.add(this.elementFromXML(xmcda, helper, startElement, eventReader));
        }
        return elements;
    }

    private LinearConstraint.Element<ELEMENT, VALUE_TYPE> elementFromXML(XMCDA xmcda, LinearConstraintParserHelper<ELEMENT> helper, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        LinearConstraint.Element element = Factory.linearConstraintElement();
        new CommonAttributesParser().handleAttributes(element, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ELEMENT.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (VARIABLE_ID.equals(startElement.getName().getLocalPart())) {
                element.setVariableID(Utils.getTextContent(startElement, eventReader));
                continue;
            }
            if (COEFFICIENT.equals(startElement.getName().getLocalPart())) {
                element.setCoefficient(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            element.setUnknown(helper.buildObject(xmcda, Utils.getTextContent(startElement, eventReader)));
        }
        return element;
    }

    public void toXML(String tagForT, LinearConstraint<ELEMENT, VALUE_TYPE> constraint, XMLStreamWriter writer) throws XMLStreamException {
        if (constraint == null) {
            return;
        }
        writer.writeStartElement(CONSTRAINT);
        new CommonAttributesParser().toXML(constraint, writer);
        writer.writeln();
        new DescriptionParser().toXML(constraint.getDescription(), writer);
        if (constraint.getElements() != null && constraint.getElements().size() > 0) {
            writer.writeStartElement(ELEMENTS);
            writer.writeln();
            for (LinearConstraint.Element<ELEMENT, VALUE_TYPE> element : constraint.getElements()) {
                writer.writeStartElement(ELEMENT);
                writer.writeln();
                if (element.getUnknown() != null) {
                    writer.writeElementChars(tagForT, ((CommonAttributes)element.getUnknown()).id());
                } else {
                    writer.writeElementChars(VARIABLE_ID, element.getVariableID());
                }
                new QualifiedValueParser<VALUE_TYPE>().toXML(COEFFICIENT, element.getCoefficient(), writer);
                writer.writeEndElement();
                writer.writeln();
            }
            writer.writeEndElement();
            writer.writeln();
        }
        writer.writeElementChars(OPERATOR, constraint.getOperator().name().toLowerCase());
        new QualifiedValueParser<VALUE_TYPE>().toXML(RHS, constraint.getRhs(), writer);
        new QualifiedValuesParser().toXML(constraint.getValues(), writer);
        writer.writeEndElement();
        writer.writeln();
    }

    public static abstract class LinearConstraintParserHelper<ELEMENT> {
        public abstract ELEMENT buildObject(XMCDA var1, String var2);
    }
}

