/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValueParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.Point;

public class PointParser {
    public static final String POINT = "point";
    public static final String ABSCISSA = "abscissa";
    public static final String ORDINATE = "ordinate";

    public Point<?, ?> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        String initialTag = startElement.getName().getLocalPart();
        Point point = new Point();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (ABSCISSA.equals(startElement.asStartElement().getName().getLocalPart())) {
                point.setAbscissa(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!ORDINATE.equals(startElement.asStartElement().getName().getLocalPart())) continue;
            point.setOrdinate(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
        }
        return point;
    }

    public void toXML(Point<?, ?> point, XMLStreamWriter writer) throws XMLStreamException {
        if (point == null) {
            return;
        }
        writer.writeStartElement(POINT);
        writer.writeln();
        new QualifiedValueParser().toXML(ABSCISSA, point.getAbscissa(), writer);
        new QualifiedValueParser().toXML(ORDINATE, point.getOrdinate(), writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

