/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.io.Serializable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CommonAttributes;
import org.xmcda.NominalScale;
import org.xmcda.QualitativeScale;
import org.xmcda.QuantitativeScale;
import org.xmcda.Scale;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.NominalScaleParser;
import org.xmcda.parsers.xml.xmcda_v3.QualitativeScaleParser;
import org.xmcda.parsers.xml.xmcda_v3.QuantitativeScaleParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class ScaleParser {
    public static final String SCALE = "scale";

    public Scale fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        StartElement initialElement = startElement;
        String initialTag = initialElement.getName().getLocalPart();
        Serializable scale = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (scale != null || !event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("nominal".equals(startElement.getName().getLocalPart())) {
                scale = new NominalScaleParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if ("qualitative".equals(startElement.getName().getLocalPart())) {
                scale = new QualitativeScaleParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (!"quantitative".equals(startElement.getName().getLocalPart())) continue;
            scale = new QuantitativeScaleParser().fromXML(xmcda, startElement, eventReader);
        }
        new CommonAttributesParser().handleAttributes((CommonAttributes)((Object)scale), initialElement);
        return scale;
    }

    public void toXML(Scale scale, XMLStreamWriter writer) throws XMLStreamException {
        this.toXML(SCALE, scale, writer);
    }

    public void toXML(String tag, Scale scale, XMLStreamWriter writer) throws XMLStreamException {
        if (scale == null) {
            return;
        }
        writer.writeStartElement(tag);
        new CommonAttributesParser().toXML(scale, writer);
        writer.writeln();
        if (scale instanceof NominalScale) {
            new NominalScaleParser().toXML((NominalScale)scale, writer);
        } else if (scale instanceof QualitativeScale) {
            new QualitativeScaleParser().toXML((QualitativeScale)scale, writer);
        } else if (scale instanceof QuantitativeScale) {
            new QuantitativeScaleParser().toXML((QuantitativeScale)scale, writer);
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

