/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.QualifiedValue;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValueParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.ValuedLabel;

public class ValuedLabelParser {
    public static final String VALUED_LABEL = QualifiedValue.XMCDATypes.VALUED_LABEL.getTag();
    public static final String LABEL = "label";
    public static final String VALUE = "value";

    public ValuedLabel fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        ValuedLabel valuedLabel = new ValuedLabel();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && VALUED_LABEL.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (LABEL.equals(startElement.getName().getLocalPart())) {
                valuedLabel.setLabel(Utils.getTextContent(startElement, eventReader));
                continue;
            }
            if (!VALUE.equals(startElement.getName().getLocalPart())) continue;
            valuedLabel.setValue(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
        }
        return valuedLabel;
    }

    public void toXML(ValuedLabel<?> valuedLabel, XMLStreamWriter writer) throws XMLStreamException {
        if (valuedLabel == null) {
            return;
        }
        writer.writeStartElement(VALUED_LABEL);
        writer.writeln();
        writer.writeElementChars(LABEL, valuedLabel.getLabel());
        new QualifiedValueParser().toXML(VALUE, valuedLabel.getValue(), writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

