/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xmcda.Alternative;
import org.xmcda.AlternativesMatrix;
import org.xmcda.AlternativesSetsMatrix;
import org.xmcda.CategoriesMatrix;
import org.xmcda.CategoriesSetsMatrix;
import org.xmcda.CriteriaMatrix;
import org.xmcda.CriteriaSetsMatrix;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesAssignmentsParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesCriteriaValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesLinearConstraintsParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesMatrixParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesSetsLinearConstraintsParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesSetsMatrixParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesSetsParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesSetsValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.AlternativesValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesLinearConstraintsParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesMatrixParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesProfilesParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesSetsLinearConstraintsParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesSetsMatrixParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesSetsParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesSetsValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaFunctionsParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaLinearConstraintsParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaMatrixParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaScalesParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaSetsLinearConstraintsParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaSetsMatrixParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaSetsParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaSetsValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaThresholdsParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.PerformanceTableParser;
import org.xmcda.parsers.xml.xmcda_v3.ProgramExecutionResultParser;
import org.xmcda.parsers.xml.xmcda_v3.ProgramParametersParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xml.sax.SAXException;

public class XMCDAParser {
    public static final String XMCDA_3_0_0 = "http://www.decision-deck.org/2013/XMCDA-3.0.0";
    public static final String XMCDA_3_0_0_location = "http://www.decision-deck.org/2013/XMCDA-3.0.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-3.0.0.xsd";
    public static final String XMCDA_3_0_0_local = "/xsd/XMCDA-3.0.0.xsd";
    public static final String XMCDA_3_0_0_prefix = "xmcda";
    public static final String XMCDA_3_0_1 = "http://www.decision-deck.org/2016/XMCDA-3.0.1";
    public static final String XMCDA_3_0_1_location = "http://www.decision-deck.org/2016/XMCDA-3.0.1 http://www.decision-deck.org/xmcda/_downloads/XMCDA-3.0.1.xsd";
    public static final String XMCDA_3_0_1_local = "/xsd/XMCDA-3.0.1.xsd";
    public static final String XMCDA_3_0_1_prefix = "xmcda";
    public static final String XMCDA_3_0_2 = "http://www.decision-deck.org/2017/XMCDA-3.0.2";
    public static final String XMCDA_3_0_2_location = "http://www.decision-deck.org/2017/XMCDA-3.0.2 http://www.decision-deck.org/xmcda/_downloads/XMCDA-3.0.2.xsd";
    public static final String XMCDA_3_0_2_local = "/xsd/XMCDA-3.0.2.xsd";
    public static final String XMCDA_3_0_2_prefix = "xmcda";

    public static boolean validate(File file) throws IOException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] source = new Source[]{new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_3_0_0_local)), new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_3_0_1_local)), new StreamSource(XMCDAParser.class.getResourceAsStream(XMCDA_3_0_2_local))};
        Schema schemaGrammar = schemaFactory.newSchema(source);
        Validator schemaValidator = schemaGrammar.newValidator();
        schemaValidator.validate(new StreamSource(file));
        return true;
    }

    public XMCDA readXMCDA(XMCDA xmcda, String filename) throws IOException, XMLStreamException, SAXException {
        return this.readXMCDA(xmcda, new File(filename));
    }

    public XMCDA readXMCDA(XMCDA xmcda, String filename, String ... tags) throws IOException, XMLStreamException, SAXException {
        return this.readXMCDA(xmcda, new File(filename), tags);
    }

    public XMCDA readXMCDA(XMCDA xmcda, File file) throws IOException, XMLStreamException, SAXException {
        return this.readXMCDA(xmcda, file, new String[0]);
    }

    private boolean handleTag(String XMCDATag, String xmlTag, String[] tagsOnly) throws NullPointerException {
        if (xmlTag == null) {
            throw new NullPointerException("xmlTag cannot be null");
        }
        if (XMCDATag == null) {
            throw new NullPointerException("XMCDATag cannot be null");
        }
        if (!XMCDATag.equals(xmlTag)) {
            return false;
        }
        if (tagsOnly == null || tagsOnly.length == 0) {
            return true;
        }
        for (String tagOnly : tagsOnly) {
            if (tagOnly == null) {
                throw new NullPointerException("tagsOnly cannot contain null values");
            }
            if (!xmlTag.equals(tagOnly)) continue;
            return true;
        }
        return false;
    }

    public XMCDA readXMCDA(XMCDA xmcda, File file, String ... tagsOnly) throws IOException, XMLStreamException, SAXException {
        if (!XMCDAParser.validate(file)) {
            throw new RuntimeException("invalid XMCDA");
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        FileInputStream in = new FileInputStream(file);
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            if (this.handleTag("alternatives", startElement.getName().getLocalPart(), tagsOnly)) {
                new AlternativesParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("alternativesSets", startElement.getName().getLocalPart(), tagsOnly)) {
                new AlternativesSetsParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("alternativesSets", startElement.getName().getLocalPart(), tagsOnly)) {
                new AlternativesSetsParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("criteria", startElement.getName().getLocalPart(), tagsOnly)) {
                new CriteriaParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("criteriaSets", startElement.getName().getLocalPart(), tagsOnly)) {
                new CriteriaSetsParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("criteriaSets", startElement.getName().getLocalPart(), tagsOnly)) {
                new CriteriaSetsParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("categories", startElement.getName().getLocalPart(), tagsOnly)) {
                new CategoriesParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("categoriesSets", startElement.getName().getLocalPart(), tagsOnly)) {
                new CategoriesSetsParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("performanceTable", startElement.getName().getLocalPart(), tagsOnly)) {
                new PerformanceTableParser().fromXML(xmcda, startElement, eventReader);
                continue;
            }
            if (this.handleTag("alternativesValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesValuesList.add(new AlternativesValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesSetsValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesSetsValuesList.add(new AlternativesSetsValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesLinearConstraints", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesLinearConstraintsList.add(new AlternativesLinearConstraintsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesSetsLinearConstraints", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesSetsLinearConstraintsList.add(new AlternativesSetsLinearConstraintsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesMatrix", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesMatricesList.add((AlternativesMatrix<?>)new AlternativesMatrixParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesSetsMatrix", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesSetsMatricesList.add((AlternativesSetsMatrix<?, ?>)new AlternativesSetsMatrixParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaFunctions", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaFunctionsList.add(new CriteriaFunctionsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaScales", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaScalesList.add(new CriteriaScalesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaThresholds", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaThresholdsList.add(new CriteriaThresholdsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaValuesList.add(new CriteriaValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaSetsValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaSetsValuesList.add(new CriteriaSetsValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaLinearConstraints", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaLinearConstraintsList.add(new CriteriaLinearConstraintsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaSetsLinearConstraints", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaSetsLinearConstraintsList.add(new CriteriaSetsLinearConstraintsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaMatrix", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaMatricesList.add((CriteriaMatrix<?>)new CriteriaMatrixParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("criteriaSetsMatrix", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.criteriaSetsMatricesList.add((CriteriaSetsMatrix<?, ?>)new CriteriaSetsMatrixParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesCriteriaValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesCriteriaValuesList.add(new AlternativesCriteriaValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("categoriesProfiles", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesProfilesList.add(new CategoriesProfilesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("alternativesAssignments", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.alternativesAssignmentsList.add(new AlternativesAssignmentsParser().fromXML(xmcda, startElement, eventReader));
            }
            if (this.handleTag("categoriesValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesValuesList.add(new CategoriesValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("categoriesSetsValues", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesSetsValuesList.add(new CategoriesSetsValuesParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("categoriesLinearConstraints", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesLinearConstraintsList.add(new CategoriesLinearConstraintsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("categoriesSetsLinearConstraints", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesSetsLinearConstraintsList.add(new CategoriesSetsLinearConstraintsParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("categoriesMatrix", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesMatricesList.add((CategoriesMatrix<?>)new CategoriesMatrixParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("categoriesSetsMatrix", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.categoriesSetsMatricesList.add((CategoriesSetsMatrix<?, ?>)new CategoriesSetsMatrixParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (this.handleTag("programParameters", startElement.getName().getLocalPart(), tagsOnly)) {
                xmcda.programParametersList.add(new ProgramParametersParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!this.handleTag("programExecutionResult", startElement.getName().getLocalPart(), tagsOnly)) continue;
            xmcda.programExecutionResultsList.add(new ProgramExecutionResultParser().fromXML(xmcda, startElement, eventReader));
        }
        return xmcda;
    }

    public void writeXMCDA(XMCDA xmcda, String contextFileName) throws FileNotFoundException, XMLStreamException {
        this.writeXMCDA(xmcda, new File(contextFileName));
    }

    public void writeXMCDA(XMCDA xmcda, String contextFileName, String ... tagsOnly) throws FileNotFoundException, XMLStreamException {
        this.writeXMCDA(xmcda, new File(contextFileName), tagsOnly);
    }

    public void writeXMCDA(XMCDA xmcda, File contextFile) throws FileNotFoundException, XMLStreamException {
        this.writeXMCDA(xmcda, contextFile, (String[])null);
    }

    public void writeXMCDA(XMCDA xmcda, File contextFile, String ... tagsOnly) throws FileNotFoundException, XMLStreamException {
        List<String> tagsOnlyList;
        if (tagsOnly == null || tagsOnly.length == 0) {
            tagsOnlyList = XMCDA.ROOT_TAGS;
        } else {
            tagsOnlyList = new ArrayList<String>(tagsOnly.length);
            for (String tag : tagsOnly) {
                tagsOnlyList.add(tag);
            }
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        javax.xml.stream.XMLStreamWriter java_writer = outputFactory.createXMLStreamWriter(new FileOutputStream(contextFile));
        XMLStreamWriter writer = new XMLStreamWriter(java_writer);
        writer.writeStartDocument();
        writer.writeCharacters("\n");
        writer.writeStartElement("xmcda", "XMCDA", XMCDA_3_0_2);
        writer.writeNamespace("xmcda", XMCDA_3_0_2);
        writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", XMCDA_3_0_2_location);
        writer.writeCharacters("\n");
        writer.writeCharacters("\n");
        if (xmcda.alternatives != null && tagsOnlyList.contains("alternatives")) {
            new AlternativesParser().toXML(xmcda.alternatives, writer);
        }
        if (xmcda.alternativesSets != null && tagsOnlyList.contains("alternativesSets")) {
            new AlternativesSetsParser().toXML(xmcda.alternativesSets, writer);
        }
        if (xmcda.criteria != null && tagsOnlyList.contains("criteria")) {
            new CriteriaParser().toXML(xmcda.criteria, writer);
        }
        if (xmcda.criteriaSets != null && tagsOnlyList.contains("criteriaSets")) {
            new CriteriaSetsParser().toXML(xmcda.criteriaSets, writer);
        }
        if (xmcda.categories != null && tagsOnlyList.contains("categories")) {
            new CategoriesParser().toXML(xmcda.categories, writer);
        }
        if (xmcda.categoriesSets != null && tagsOnlyList.contains("categoriesSets")) {
            new CategoriesSetsParser().toXML(xmcda.categoriesSets, writer);
        }
        if (xmcda.performanceTablesList != null && tagsOnlyList.contains("performanceTable")) {
            new PerformanceTableParser().toXML(xmcda.performanceTablesList, writer);
        }
        if (xmcda.alternativesValuesList != null && tagsOnlyList.contains("alternativesValues")) {
            new AlternativesValuesParser().toXML(xmcda.alternativesValuesList, writer);
        }
        if (xmcda.alternativesSetsValuesList != null && tagsOnlyList.contains("alternativesSetsValues")) {
            new AlternativesSetsValuesParser().toXML(xmcda.alternativesSetsValuesList, writer);
        }
        if (xmcda.alternativesLinearConstraintsList != null && tagsOnlyList.contains("alternativesLinearConstraints")) {
            new AlternativesLinearConstraintsParser().toXML(xmcda.alternativesLinearConstraintsList, writer);
        }
        if (xmcda.alternativesSetsLinearConstraintsList != null && tagsOnlyList.contains("alternativesSetsLinearConstraints")) {
            new AlternativesSetsLinearConstraintsParser().toXML(xmcda.alternativesSetsLinearConstraintsList, writer);
        }
        if (xmcda.alternativesMatricesList != null && tagsOnlyList.contains("alternativesMatrix")) {
            new AlternativesMatrixParser().toXML(xmcda.alternativesMatricesList, writer);
        }
        if (xmcda.alternativesSetsMatricesList != null && tagsOnlyList.contains("alternativesSetsMatrix")) {
            new AlternativesSetsMatrixParser().toXML(xmcda.alternativesSetsMatricesList, writer);
        }
        if (xmcda.criteriaFunctionsList != null && tagsOnlyList.contains("criteriaFunctions")) {
            new CriteriaFunctionsParser().toXML(xmcda.criteriaFunctionsList, writer);
        }
        if (xmcda.criteriaScalesList != null && tagsOnlyList.contains("criteriaScales")) {
            new CriteriaScalesParser().toXML(xmcda.criteriaScalesList, writer);
        }
        if (xmcda.criteriaThresholdsList != null && tagsOnlyList.contains("criteriaThresholds")) {
            new CriteriaThresholdsParser().toXML(xmcda.criteriaThresholdsList, writer);
        }
        if (xmcda.criteriaValuesList != null && tagsOnlyList.contains("criteriaValues")) {
            new CriteriaValuesParser().toXML(xmcda.criteriaValuesList, writer);
        }
        if (xmcda.criteriaSetsValuesList != null && tagsOnlyList.contains("criteriaSetsValues")) {
            new CriteriaSetsValuesParser().toXML(xmcda.criteriaSetsValuesList, writer);
        }
        if (xmcda.criteriaLinearConstraintsList != null && tagsOnlyList.contains("criteriaLinearConstraints")) {
            new CriteriaLinearConstraintsParser().toXML(xmcda.criteriaLinearConstraintsList, writer);
        }
        if (xmcda.criteriaSetsLinearConstraintsList != null && tagsOnlyList.contains("criteriaSetsLinearConstraints")) {
            new CriteriaSetsLinearConstraintsParser().toXML(xmcda.criteriaSetsLinearConstraintsList, writer);
        }
        if (xmcda.criteriaMatricesList != null && tagsOnlyList.contains("criteriaMatrix")) {
            new CriteriaMatrixParser().toXML(xmcda.criteriaMatricesList, writer);
        }
        if (xmcda.criteriaSetsMatricesList != null && tagsOnlyList.contains("criteriaSetsMatrix")) {
            new CriteriaSetsMatrixParser().toXML(xmcda.criteriaSetsMatricesList, writer);
        }
        if (xmcda.alternativesCriteriaValuesList != null && tagsOnlyList.contains("alternativesCriteriaValues")) {
            new AlternativesCriteriaValuesParser().toXML(xmcda.alternativesCriteriaValuesList, writer);
        }
        if (xmcda.categoriesProfilesList != null && tagsOnlyList.contains("categoriesProfiles")) {
            new CategoriesProfilesParser().toXML(xmcda.categoriesProfilesList, writer);
        }
        if (xmcda.alternativesAssignmentsList != null && tagsOnlyList.contains("alternativesAssignments")) {
            new AlternativesAssignmentsParser().toXML(xmcda.alternativesAssignmentsList, writer);
        }
        if (xmcda.categoriesValuesList != null && tagsOnlyList.contains("categoriesValues")) {
            new CategoriesValuesParser().toXML(xmcda.categoriesValuesList, writer);
        }
        if (xmcda.categoriesSetsValuesList != null && tagsOnlyList.contains("categoriesSetsValues")) {
            new CategoriesSetsValuesParser().toXML(xmcda.categoriesSetsValuesList, writer);
        }
        if (xmcda.categoriesLinearConstraintsList != null && tagsOnlyList.contains("categoriesLinearConstraints")) {
            new CategoriesLinearConstraintsParser().toXML(xmcda.categoriesLinearConstraintsList, writer);
        }
        if (xmcda.categoriesSetsLinearConstraintsList != null && tagsOnlyList.contains("categoriesSetsLinearConstraints")) {
            new CategoriesSetsLinearConstraintsParser().toXML(xmcda.categoriesSetsLinearConstraintsList, writer);
        }
        if (xmcda.categoriesMatricesList != null && tagsOnlyList.contains("categoriesMatrix")) {
            new CategoriesMatrixParser().toXML(xmcda.categoriesMatricesList, writer);
        }
        if (xmcda.categoriesSetsMatricesList != null && tagsOnlyList.contains("categoriesSetsMatrix")) {
            new CategoriesSetsMatrixParser().toXML(xmcda.categoriesSetsMatricesList, writer);
        }
        if (xmcda.programParametersList != null && tagsOnlyList.contains("programParameters")) {
            new ProgramParametersParser().toXML(xmcda.programParametersList, writer);
        }
        if (xmcda.programExecutionResultsList != null && tagsOnlyList.contains("programExecutionResult")) {
            new ProgramExecutionResultParser().toXML(xmcda.programExecutionResultsList, writer);
        }
        writer.writeEndDocument();
        writer.writeln();
        writer.close();
    }

    public static void main(String[] args) throws Throwable {
        XMCDA xmcda = new XMCDA();
        XMCDAParser reader = new XMCDAParser();
        reader.readXMCDA(xmcda, "test.xml");
        for (Alternative alternative : xmcda.alternatives) {
            System.out.println(alternative);
        }
        reader.writeXMCDA(xmcda, "test-out.xml");
    }
}

