/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.CheckEntryFiles;
import Main.OutputMessage;
import Main.OutputValFunc;
import Main.ParseAlternatives;
import Main.ParseAlternativesRank;
import Main.ParseCriteria;
import Main.ParseParameters;
import Main.ParsePerfTable;
import Main.parsePrefDirec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import utafx.Alternative;
import utafx.Criterion;
import utafx.LinearFunction;
import utafx.Ranking;
import utafx.UtaStarSolver;

public class RunUta {
    static Document document;
    static Element racine;
    private String error = "";
    private String warning = "";
    private ArrayList<String> listCriterionID = new ArrayList();
    private ArrayList<String> listAlternativeID = new ArrayList();
    private float[][] matricePerf;
    private static final String XMCDA_2_0_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.0.0";
    private static final String XMCDA_2_0_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd";
    private static final String XMCDA_2_1_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.1.0";
    private static final String XMCDA_2_1_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.1.0.xsd";
    private static final String XMCDA_2_2_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.2.0";
    private static final String XMCDA_2_2_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.2.0.xsd";
    private static final String ACCEPTED_SCHEMA_LOCATIONS = "http://www.decision-deck.org/2009/XMCDA-2.0.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd http://www.decision-deck.org/2009/XMCDA-2.1.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.1.0.xsd http://www.decision-deck.org/2009/XMCDA-2.2.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.2.0.xsd";

    public RunUta() {
        this.matricePerf = new float[100][100];
    }

    public RunUta(ArrayList<String> listAlt, ArrayList<String> listCrit, float[][] matricePerfToUse) {
        int i = 0;
        while (i < listAlt.size()) {
            this.listAlternativeID.add(listAlt.get(i));
            ++i;
        }
        i = 0;
        while (i < listCrit.size()) {
            this.listCriterionID.add(listCrit.get(i));
            ++i;
        }
        this.matricePerf = new float[listAlt.size()][listCrit.size()];
        int l = 0;
        while (l < listAlt.size()) {
            int c = 0;
            while (c < listCrit.size()) {
                this.matricePerf[l][c] = matricePerfToUse[l][c];
                ++c;
            }
            ++l;
        }
    }

    protected float getMatrixElement(int indexAlt, int indexCrit) {
        return this.matricePerf[indexAlt][indexCrit];
    }

    public String getError() {
        return this.error;
    }

    public String getWarning() {
        return this.warning;
    }

    protected static String checkEntryFile(String path) {
        String error = "";
        try {
            RunUta.parseXML(path);
        }
        catch (JDOMException e) {
            error = error.concat("File is not well-formed: " + e.getMessage());
        }
        catch (IOException e) {
            error = error.concat("Could not check file because: " + e.getMessage());
        }
        return error;
    }

    protected static void parseXML(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)ACCEPTED_SCHEMA_LOCATIONS);
        Document doc = builder.build(xml);
    }

    protected static void PrepareParsing(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        racine = document.getRootElement();
    }

    public RunUta checkCoherentEntryFiles(RunUta perfTableAfterParsingXML, ArrayList<String> listAlternatives, ArrayList<String> listCriteria) {
        ArrayList<String> listintersectionCriteria;
        ArrayList<String> listintersectionAlternatives;
        String warning = "";
        CheckEntryFiles check = new CheckEntryFiles();
        boolean checkAlt = check.checkIDs(listAlternatives, perfTableAfterParsingXML, "alternatives");
        boolean checkCrit = check.checkIDs(listCriteria, perfTableAfterParsingXML, "criteria");
        if (!checkAlt) {
            warning = warning.concat(check.getWarningAlternatives());
        }
        if (!checkCrit) {
            warning = warning.concat(check.getWarningCriteria());
        }
        if ((listintersectionAlternatives = check.getIntersectionIDs(listAlternatives, perfTableAfterParsingXML, "alternatives")).isEmpty()) {
            warning = warning.concat("\nOnly the alternativesIDs in the file containing the performance table tag were considered. Please check your input file containing the alternatives tag.");
            int i = 0;
            while (i < perfTableAfterParsingXML.getListAlternatives().size()) {
                listintersectionAlternatives.add(perfTableAfterParsingXML.getListAlternatives().get(i));
                ++i;
            }
        }
        if ((listintersectionCriteria = check.getIntersectionIDs(listCriteria, perfTableAfterParsingXML, "criteria")).isEmpty()) {
            warning = warning.concat("\nOnly the criterionIDs in the file containing the performance table tag were considered. Please check your input file containing the criteria tag.");
            int i = 0;
            while (i < perfTableAfterParsingXML.getListCriteria().size()) {
                System.out.println(perfTableAfterParsingXML.getListCriteria().get(i));
                listintersectionCriteria.add(perfTableAfterParsingXML.getListCriteria().get(i));
                ++i;
            }
        }
        float[][] matricePerf = new float[listintersectionAlternatives.size()][listintersectionCriteria.size()];
        int l = 0;
        while (l < listintersectionAlternatives.size()) {
            int c = 0;
            while (c < listintersectionCriteria.size()) {
                matricePerf[l][c] = perfTableAfterParsingXML.getMatrixElement(perfTableAfterParsingXML.getListAlternatives().indexOf(listintersectionAlternatives.get(l)), perfTableAfterParsingXML.getListCriteria().indexOf(listintersectionCriteria.get(c)));
                ++c;
            }
            ++l;
        }
        RunUta result = new RunUta(listintersectionAlternatives, listintersectionCriteria, matricePerf);
        result.warning = warning;
        return result;
    }

    protected static double getMin(RunUta projectUta, int indexCriterion) {
        double min = projectUta.getMatrixElement(0, indexCriterion);
        int i = 1;
        while (i < projectUta.getListAlternatives().size()) {
            double temp = projectUta.getMatrixElement(i, indexCriterion);
            if (temp < min) {
                min = temp;
            }
            ++i;
        }
        return min;
    }

    protected static double getMax(RunUta projectUta, int indexCriterion) {
        double max = projectUta.getMatrixElement(0, indexCriterion);
        int i = 1;
        while (i < projectUta.getListAlternatives().size()) {
            double temp = projectUta.getMatrixElement(i, indexCriterion);
            if (temp > max) {
                max = temp;
            }
            ++i;
        }
        return max;
    }

    protected static double getValue(String worstBest, RunUta projectUta, int indexCriterion, String preferenceDirection) {
        double bestWorst = 0.0;
        if (worstBest.equals("worst")) {
            if (preferenceDirection.equals("min")) {
                bestWorst = RunUta.getMax(projectUta, indexCriterion);
            } else if (preferenceDirection.equals("max")) {
                bestWorst = RunUta.getMin(projectUta, indexCriterion);
            }
        } else if (worstBest.equals("best")) {
            if (preferenceDirection.equals("min")) {
                bestWorst = RunUta.getMin(projectUta, indexCriterion);
            } else if (preferenceDirection.equals("max")) {
                bestWorst = RunUta.getMax(projectUta, indexCriterion);
            }
        }
        return bestWorst;
    }

    protected static List<Criterion> createCriteria(RunUta projectUta, int[] segments, String[] preferenceDirection) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        int i = 0;
        while (i < projectUta.getListCriteria().size()) {
            double worstValue = RunUta.getValue("worst", projectUta, i, preferenceDirection[i]);
            double bestValue = RunUta.getValue("best", projectUta, i, preferenceDirection[i]);
            criteria.add(new Criterion(worstValue, bestValue, segments[i]));
            ++i;
        }
        return criteria;
    }

    protected static Alternative[] createActions(RunUta projectUta, List<Criterion> criteria) {
        Alternative[] alternatives = new Alternative[projectUta.getListAlternatives().size()];
        int i = 0;
        while (i < projectUta.getListAlternatives().size()) {
            Alternative alter;
            int nbrOfCriteria = projectUta.getListCriteria().size();
            double[] values = new double[nbrOfCriteria];
            int j = 0;
            while (j < nbrOfCriteria) {
                values[j] = projectUta.getMatrixElement(i, j);
                ++j;
            }
            alternatives[i] = alter = new Alternative(values, criteria);
            ++i;
        }
        return alternatives;
    }

    protected static int getNumberOfElements(double[] ranks) {
        int nbrOfElements = 0;
        int i = 0;
        while (i < ranks.length) {
            if (ranks[i] != -1.0) {
                ++nbrOfElements;
            }
            ++i;
        }
        return nbrOfElements;
    }

    protected static Alternative[] getAlternativesForUTA(double[] ranks, Alternative[] alternatives) {
        int nbrOfElements = RunUta.getNumberOfElements(ranks);
        Alternative[] result = new Alternative[nbrOfElements];
        int index = 0;
        int i = 0;
        while (i < ranks.length) {
            if (ranks[i] != -1.0) {
                result[index] = alternatives[i];
                ++index;
            }
            ++i;
        }
        return result;
    }

    protected static double[] getRanksForUTA(double[] ranks) {
        int nbrOfElements = RunUta.getNumberOfElements(ranks);
        double[] result = new double[nbrOfElements];
        int index = 0;
        int i = 0;
        while (i < ranks.length) {
            if (ranks[i] != -1.0) {
                result[index] = ranks[i];
                ++index;
            }
            ++i;
        }
        return result;
    }

    protected static void ordonate(double[] ranksForUTA, Alternative[] alternativesWithRanks) {
        int i = 0;
        while (i < ranksForUTA.length - 1) {
            int j = i + 1;
            while (j < ranksForUTA.length) {
                if (ranksForUTA[i] > ranksForUTA[j]) {
                    double temp = ranksForUTA[j];
                    ranksForUTA[j] = ranksForUTA[i];
                    ranksForUTA[i] = temp;
                    Alternative tempAlt = alternativesWithRanks[j];
                    alternativesWithRanks[j] = alternativesWithRanks[i];
                    alternativesWithRanks[i] = tempAlt;
                }
                ++j;
            }
            ++i;
        }
    }

    protected static void round(LinearFunction[] actuals, int number) {
        int i = 0;
        while (i < actuals.length) {
            int nbrOfPoints = actuals[i].getNoOfPoints();
            int j = 0;
            while (j < nbrOfPoints) {
                double x = actuals[i].getPoints().get(j).getX();
                x = (double)Math.round(x * 100.0) / 100.0;
                actuals[i].getPoints().get(j).setX(x);
                double y = actuals[i].getPoints().get(j).getY();
                y = (double)Math.round(y * 100.0) / 100.0;
                actuals[i].getPoints().get(j).setY(y);
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] argv) {
        RunUta uta = new RunUta();
        boolean stopRunning = false;
        if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists() && new File(argv[3]).exists() && new File(argv[4]).exists() && new File(argv[5]).exists() && argv.length == 8)) {
            stopRunning = true;
        }
        if (stopRunning) {
            uta.error = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            String pathParameters = argv[0];
            String pathAlternatives = argv[1];
            String pathAlternativesRanking = argv[2];
            String pathCriteria = argv[3];
            String pathPerfTable = argv[4];
            String pathCriterSegments = argv[5];
            String errMethodParameters = RunUta.checkEntryFile(pathParameters);
            String errAltern = RunUta.checkEntryFile(pathAlternatives);
            String errAlternRanking = RunUta.checkEntryFile(pathAlternativesRanking);
            String errCriter = RunUta.checkEntryFile(pathCriteria);
            String errPerfTable = RunUta.checkEntryFile(pathPerfTable);
            String errCriterSegments = RunUta.checkEntryFile(pathCriterSegments);
            if (errMethodParameters != "") {
                uta.error = uta.error.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
            }
            if (errAltern != "") {
                uta.error = uta.error.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
            }
            if (errAlternRanking != "") {
                uta.error = uta.error.concat("\nFatal Error: the file containing the alternativesValues (alternativesRanking) tag is not a valid XMCDA document.");
            }
            if (errCriter != "") {
                uta.error = uta.error.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if (errPerfTable != "") {
                uta.error = uta.error.concat("\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document.");
            }
            if (errCriterSegments != "") {
                uta.error = uta.error.concat("\nFatal Error: the file containing the criteriaValues (criteriaSegments) tag is not a valid XMCDA document.");
            }
            if (errMethodParameters != "" || errAltern != "" || errAlternRanking != "" || errCriter != "" || errPerfTable != "" || errCriterSegments != "") {
                OutputMessage xmcdaMess = new OutputMessage();
                xmcdaMess.createErrorMessage(uta.getError());
                String pathOutputMessage = argv[argv.length - 1];
                xmcdaMess.save(pathOutputMessage);
            } else {
                RunUta.PrepareParsing(pathParameters);
                ParseParameters parseParam = new ParseParameters();
                boolean parseParametersNull = false;
                boolean statusParameters = parseParam.parse(racine);
                if (!statusParameters) {
                    parseParametersNull = true;
                    uta.error = "\nFatal Error: the file containing the method parameters tag is erroneous or empty.";
                }
                if (parseParam.getWarning() != "") {
                    uta.warning = uta.warning.equals("") ? "\n" + parseParam.getWarning() : uta.warning.concat("\n" + parseParam.getWarning());
                }
                boolean doPostOptimalAnalysis = parseParam.postOptimatily();
                RunUta.PrepareParsing(pathAlternatives);
                ParseAlternatives parseAlter = new ParseAlternatives();
                boolean parseAlternativesNull = false;
                ArrayList<String> alterIds = parseAlter.exploreAlternativesXML(racine);
                if (parseAlter.getWarning() != "") {
                    uta.warning = uta.warning.equals("") ? "\n" + parseAlter.getWarning() : uta.warning.concat("\n" + parseAlter.getWarning());
                }
                if (alterIds == null) {
                    parseAlternativesNull = true;
                    uta.error = uta.error.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : uta.error.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                RunUta.PrepareParsing(pathCriteria);
                ParseCriteria parseCriter = new ParseCriteria();
                boolean parseCriterNull = false;
                ArrayList<String> criterIds = parseCriter.exploreCriteriaXML(racine);
                String[] parsePreferenceDirection = parseCriter.getPreferenceDirections();
                if (parseCriter.getWarning() != "") {
                    uta.warning = uta.warning.equals("") ? "\n" + parseCriter.getWarning() : uta.warning.concat("\n" + parseCriter.getWarning());
                }
                if (criterIds == null) {
                    parseCriterNull = true;
                    uta.error = uta.error.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty: " + parseCriter.getWarning() : uta.error.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty: " + parseCriter.getWarning());
                }
                RunUta.PrepareParsing(pathPerfTable);
                ParsePerfTable jdomPerfTable = new ParsePerfTable();
                boolean parsePerfTableNull = false;
                RunUta perfTable = jdomPerfTable.explorePerformanceTable(racine);
                if (jdomPerfTable.getErrorMessage() != "") {
                    uta.warning = uta.warning.concat("\n" + jdomPerfTable.getErrorMessage());
                }
                if (jdomPerfTable.getWarningMessage() != "") {
                    uta.warning = uta.warning.concat("\n" + jdomPerfTable.getWarningMessage());
                }
                if (perfTable == null) {
                    parsePerfTableNull = true;
                    uta.error = uta.error.equals("") ? "\nFatal Error: the file containing the performanceTable tag is erroneous or empty." : uta.error.concat("\nFatal Error: the file containing the performanceTable tag is erroneous or empty.");
                }
                if (!(parseCriterNull || parseAlternativesNull || parsePerfTableNull || parseParametersNull)) {
                    String pathOutputMessage;
                    OutputMessage xmcdaMess;
                    RunUta projectUta = uta.checkCoherentEntryFiles(perfTable, alterIds, criterIds);
                    projectUta.error = projectUta.getError() != "" ? String.valueOf(uta.error) + "\n" + projectUta.getError() : uta.error;
                    projectUta.warning = projectUta.getWarning() != "" ? String.valueOf(uta.warning) + "\n" + projectUta.getWarning() : uta.warning;
                    RunUta.PrepareParsing(pathCriterSegments);
                    parsePrefDirec parseSegments = new parsePrefDirec();
                    boolean parseSegmentsNull = false;
                    int[] segments = parseSegments.parseSegments(racine, projectUta.getListCriteria());
                    if (parseSegments.getWarningMessage() != "") {
                        projectUta.warning = projectUta.warning.concat("\n" + parseSegments.getWarningMessage());
                    }
                    if (segments == null) {
                        parseSegmentsNull = true;
                        projectUta.error = projectUta.error.equals("") ? "\nFatal Error: the entry file 'criteriaSegments' is erroneous or empty." : projectUta.error.concat("\nFatal Error: the entry file 'criteriaSegments' is erroneous or empty.");
                    }
                    RunUta.PrepareParsing(pathAlternativesRanking);
                    ParseAlternativesRank parseAlterRank = new ParseAlternativesRank();
                    boolean parseAlternativesRankNull = false;
                    double[] ranks = parseAlterRank.getRanks(racine, projectUta.getListAlternatives());
                    if (parseAlterRank.getWarningMessage() != "") {
                        projectUta.warning = projectUta.warning.concat("\n" + parseAlterRank.getWarningMessage());
                    }
                    if (ranks == null) {
                        parseAlternativesRankNull = true;
                        projectUta.error = projectUta.error.equals("") ? "\nFatal Error: the entry file 'alternativesRanks' is erroneous or empty." : projectUta.error.concat("\nFatal Error: the entry file 'alternativesRanks' is erroneous or empty.");
                    }
                    if (projectUta.getListAlternatives().size() != 0 && projectUta.getListCriteria().size() != 0) {
                        if (!parseSegmentsNull) {
                            UtaStarSolver starSolver = new UtaStarSolver(doPostOptimalAnalysis);
                            List<Criterion> criteria = RunUta.createCriteria(projectUta, segments, parsePreferenceDirection);
                            Alternative[] alternatives = RunUta.createActions(projectUta, criteria);
                            if (!parseAlternativesRankNull) {
                                Alternative[] alternativesWithRanks = RunUta.getAlternativesForUTA(ranks, alternatives);
                                double[] ranksForUTA = RunUta.getRanksForUTA(ranks);
                                RunUta.ordonate(ranksForUTA, alternativesWithRanks);
                                Ranking<Alternative> ranking = new Ranking<Alternative>(ranksForUTA, alternativesWithRanks);
                                ArrayList<Alternative> alternativesWithRanksList = new ArrayList<Alternative>();
                                int i = 0;
                                while (i < alternativesWithRanks.length) {
                                    alternativesWithRanksList.add(alternativesWithRanks[i]);
                                    ++i;
                                }
                                LinearFunction[] actuals = starSolver.solve(ranking, criteria);
                                RunUta.round(actuals, 2);
                                OutputValFunc output = new OutputValFunc();
                                output.createOutputFile(actuals, projectUta.getListCriteria());
                                String pathOutputFile = argv[argv.length - 2];
                                output.save(pathOutputFile);
                            }
                        }
                    } else {
                        projectUta.error = projectUta.error.concat("\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n");
                    }
                    if (!parseSegmentsNull && !parseAlternativesRankNull) {
                        xmcdaMess = new OutputMessage();
                        xmcdaMess.createLogMessage(projectUta.warning, projectUta.error);
                        pathOutputMessage = argv[argv.length - 1];
                        xmcdaMess.save(pathOutputMessage);
                    } else {
                        xmcdaMess = new OutputMessage();
                        xmcdaMess.createErrorMessage(projectUta.error);
                        pathOutputMessage = argv[argv.length - 1];
                        xmcdaMess.save(pathOutputMessage);
                    }
                } else {
                    OutputMessage xmcdaMess = new OutputMessage();
                    xmcdaMess.createErrorMessage(uta.getError());
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.save(pathOutputMessage);
                }
            }
        } else {
            OutputMessage xmcdaMess = new OutputMessage();
            xmcdaMess.createErrorMessage(uta.getError());
            String pathOutputMessage = argv[argv.length - 1];
            xmcdaMess.save(pathOutputMessage);
        }
    }

    public ArrayList<String> getListAlternatives() {
        return this.listAlternativeID;
    }

    public ArrayList<String> getListCriteria() {
        return this.listCriterionID;
    }
}

