/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.Arrays;
import java.util.List;
import utafx.Criterion;
import utafx.LinearFunction;

public class Alternative
implements Comparable<Alternative> {
    private String name = Integer.toString(this.hashCode());
    private List<Criterion> criteria;
    private double[] values;

    public Alternative() {
    }

    public Alternative(double[] values, List<Criterion> criteria) {
        this();
        this.criteria = criteria;
        this.values = values;
    }

    public Alternative(double[] values, Criterion ... criteria) {
        this(values, Arrays.asList(criteria));
    }

    public double getValueOn(Criterion criterion) {
        int criterionIndex = this.getIndexOf(criterion);
        return this.values[criterionIndex];
    }

    public double getValueOn(int criterionIndex) {
        return this.values[criterionIndex];
    }

    @Override
    public int compareTo(Alternative o) {
        return Integer.valueOf(this.hashCode()).compareTo(o.hashCode());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValues(double[] newValues) {
        this.values = newValues;
    }

    public void setCriteria(Criterion[] criteria) {
        this.criteria = Arrays.asList(criteria);
    }

    public double[] getValues() {
        return this.values;
    }

    private int getIndexOf(Criterion criterion) {
        int index = this.criteria.indexOf(criterion);
        if (index == -1) {
            for (Criterion c : this.criteria) {
                ++index;
                if (!c.getName().equals(criterion.getName())) continue;
                return index;
            }
        }
        return index;
    }

    public double getGeneralUtil(LinearFunction[] functions) {
        double util = 0.0;
        LinearFunction[] linearFunctionArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction function = linearFunctionArray[n2];
            double value = this.getValueOn(function.getCriterion());
            util += function.getValueAt(value);
            ++n2;
        }
        return util;
    }
}

