/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.HashMap;
import java.util.Map;
import utafx.Alternative;
import utafx.Constraint;
import utafx.LinearFunction;
import utafx.Point;
import utafx.Ranking;
import utafx.RankingUtils;
import utafx.StandardConstraintsManager;

public class ConstantKendallConstraintsManager
extends StandardConstraintsManager {
    public static final double SEARCH_PRECISION = 1.0E-21;
    private static final RankingUtils RANKING_UTILS = new RankingUtils();
    private final Ranking<Alternative> referenceRank;
    private Ranking<Alternative> finalRank;
    private final double currentKendall;
    protected Map<Point, Constraint> modifiedConstraints = new HashMap<Point, Constraint>();

    public ConstantKendallConstraintsManager(LinearFunction[] functions, Ranking<Alternative> referenceRank, Ranking<Alternative> finalRank) {
        super(functions);
        this.referenceRank = referenceRank;
        this.finalRank = finalRank;
        this.currentKendall = RANKING_UTILS.getKendallsCoefficient(this.referenceRank, this.finalRank);
        this.initModifiedConstraints();
        this.updateConstraints();
    }

    private void initModifiedConstraints() {
        for (Point p : this.constraints.keySet()) {
            Constraint constraint = (Constraint)this.constraints.get(p);
            double lowerBound = constraint.getLowerBound();
            double upperBound = constraint.getUpperBound();
            this.updateOrCreateConstraint(this.modifiedConstraints, p, lowerBound, upperBound);
        }
    }

    private boolean isBestPoint(Point p) {
        LinearFunction[] linearFunctionArray = this.functions;
        int n = this.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LinearFunction f = linearFunctionArray[n2];
            if (f.getBestPoint().equals(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void updateConstraints() {
        for (Point p : this.constraints.keySet()) {
            if (this.isBestPoint(p)) continue;
            this.updatePoint(p);
        }
        for (Point p : this.constraints.keySet()) {
            if (!this.isBestPoint(p)) continue;
            this.updatePoint(p);
        }
    }

    private void updatePoint(Point p) {
        Constraint c = (Constraint)this.constraints.get(p);
        double newConstraintValue = this.search(p, c, c.getUpperBound(), p.getY(), true);
        this.setNewUpperBound(p, newConstraintValue);
        newConstraintValue = this.search(p, c, p.getY(), c.getLowerBound(), false);
        this.setNewLowerBound(p, newConstraintValue);
    }

    private double search(Point p, Constraint c, double high, double low, boolean searchUpwards) {
        double middle = (high + low) / 2.0;
        double prevMiddle = high;
        double previousHigh = high;
        double previousLow = low;
        while (Math.abs(middle - prevMiddle) > 1.0E-21) {
            prevMiddle = middle;
            boolean isWorse = this.isKendallWorseWhenPointHasValue(p, middle);
            if (isWorse == searchUpwards) {
                previousHigh = middle;
                middle = (middle + previousLow) / 2.0;
                continue;
            }
            previousLow = middle;
            middle = (middle + previousHigh) / 2.0;
        }
        return middle;
    }

    private void setNewLowerBound(Point p, double middle) {
        this.modifiedConstraints.get(p).setLowerBound(middle);
    }

    private void setNewUpperBound(Point p, double middle) {
        this.modifiedConstraints.get(p).setUpperBound(middle);
    }

    boolean isKendallWorseWhenPointHasValue(Point p, double value) {
        return this.isBestPoint(p) ? this.isKendallWorseWhenBestPointHasValue(p, value) : this.isKendallWorseWhenMiddlePointHasValue(p, value);
    }

    boolean isKendallWorseWhenMiddlePointHasValue(Point p, double value) {
        LinearFunction[] deepCopy = new LinearFunction[this.functions.length];
        int functionIndex = 0;
        int i = 0;
        while (i < this.functions.length) {
            if (this.functions[i].containsPoint(p)) {
                functionIndex = i;
            }
            deepCopy[i] = new LinearFunction(this.functions[i]);
            ++i;
        }
        deepCopy[functionIndex].setPointAt(p.getX(), new Point(p.getX(), value));
        Ranking<Alternative> newRank = RANKING_UTILS.buildRank(deepCopy, this.referenceRank.getAlternatives());
        double newKendall = RANKING_UTILS.getKendallsCoefficient(this.referenceRank, newRank);
        return newKendall < this.currentKendall;
    }

    boolean isKendallWorseWhenBestPointHasValue(Point p, double value) {
        LinearFunction[] deepCopy = new LinearFunction[this.functions.length];
        int functionIndex = 0;
        int i = 0;
        while (i < this.functions.length) {
            if (this.functions[i].containsPoint(p)) {
                functionIndex = i;
            }
            deepCopy[i] = new LinearFunction(this.functions[i]);
            ++i;
        }
        Point newPoint = new Point(p.getX(), value);
        HashMap<Point, Constraint> constraints = new HashMap<Point, Constraint>();
        Constraint newConstraint = new Constraint(newPoint);
        constraints.put(newPoint, newConstraint);
        newConstraint.setLowerBound(((Constraint)this.constraints.get(p)).getLowerBound());
        newConstraint.setUpperBound(((Constraint)this.constraints.get(p)).getUpperBound());
        deepCopy[functionIndex].setPointAt(p.getX(), newPoint);
        int i2 = 0;
        while (i2 < this.functions.length) {
            Constraint c = (Constraint)this.constraints.get(this.functions[i2].getBestPoint());
            constraints.put(deepCopy[i2].getBestPoint(), c);
            ++i2;
        }
        this.doBestPointUpdate(deepCopy[functionIndex], deepCopy, false, constraints);
        Ranking<Alternative> newRank = RANKING_UTILS.buildRank(deepCopy, this.referenceRank.getAlternatives());
        double newKendall = RANKING_UTILS.getKendallsCoefficient(this.referenceRank, newRank);
        return newKendall < this.currentKendall;
    }

    @Override
    public void update(LinearFunction function, Point changedPoint) {
        super.update(function, changedPoint);
        this.buildConstraints();
        this.initModifiedConstraints();
        this.updateConstraints();
    }

    @Override
    public Constraint[] getConstraints() {
        return this.modifiedConstraints.values().toArray(new Constraint[this.constraints.size()]);
    }

    @Override
    public Constraint getConstraintFor(Point p) {
        return this.modifiedConstraints.get(p);
    }
}

