/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import utafx.Alternative;
import utafx.AssertHelper;
import utafx.Criterion;
import utafx.LinearFunction;
import utafx.Ranking;
import utafx.UtaStarSolver;

public class FunctionalTest {
    @Test
    public void testSolve01() {
        UtaStarSolver starSolver = new UtaStarSolver(false);
        Criterion price = new Criterion(30.0, 2.0, 2);
        Criterion time = new Criterion(40.0, 10.0, 3);
        Criterion comfort = new Criterion(0.0, 3.0, 3);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(price);
        criteria.add(time);
        criteria.add(comfort);
        Alternative rer = new Alternative(new double[]{3.0, 10.0, 1.0}, criteria);
        Alternative metro1 = new Alternative(new double[]{4.0, 20.0, 2.0}, criteria);
        Alternative metro2 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative bus = new Alternative(new double[]{6.0, 40.0, 0.0}, criteria);
        Alternative taxi = new Alternative(new double[]{30.0, 30.0, 3.0}, criteria);
        Ranking<Alternative> ranking = new Ranking<Alternative>(new double[]{1.0, 2.0, 2.0, 3.0, 4.0}, rer, metro1, metro2, bus, taxi);
        LinearFunction[] actuals = starSolver.solve(ranking, criteria);
        double[][] expecteds = new double[][]{{0.0, 0.5, 0.5}, {0.0, 0.05, 0.05, 0.1}, {0.0, 0.0, 0.0, 0.4}};
        int i = 0;
        while (i < expecteds.length) {
            AssertHelper.assertArraysEqual(expecteds[i], actuals[i].getValues());
            ++i;
        }
    }

    @Test
    public void testSolve02() {
        UtaStarSolver starSolver = new UtaStarSolver(false);
        Criterion price = new Criterion(2, false);
        Criterion time = new Criterion(3, false);
        Criterion comfort = new Criterion(3, true);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(price);
        criteria.add(time);
        criteria.add(comfort);
        Alternative rer = new Alternative(new double[]{3.0, 10.0, 1.0}, criteria);
        Alternative metro1 = new Alternative(new double[]{4.0, 20.0, 2.0}, criteria);
        Alternative metro2 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative bus = new Alternative(new double[]{6.0, 40.0, 0.0}, criteria);
        Alternative taxi = new Alternative(new double[]{30.0, 30.0, 3.0}, criteria);
        Ranking<Alternative> ranking = new Ranking<Alternative>(new double[]{1.0, 2.0, 2.0, 3.0, 4.0}, rer, metro1, metro2, bus, taxi);
        LinearFunction[] actuals = starSolver.solve(ranking, criteria, Arrays.asList(rer, metro1, metro2, bus, taxi));
        double[][] expecteds = new double[][]{{0.0, 0.5, 0.5}, {0.0, 0.05, 0.05, 0.1}, {0.0, 0.0, 0.0, 0.4}};
        int i = 0;
        while (i < expecteds.length) {
            AssertHelper.assertArraysEqual(expecteds[i], actuals[i].getValues());
            ++i;
        }
    }

    @Test
    public void testSolve03() {
        UtaStarSolver starSolver = new UtaStarSolver(true);
        Criterion price = new Criterion(2, false);
        Criterion time = new Criterion(3, false);
        Criterion comfort = new Criterion(3, true);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(price);
        criteria.add(time);
        criteria.add(comfort);
        Alternative rer = new Alternative(new double[]{3.0, 10.0, 1.0}, criteria);
        Alternative metro1 = new Alternative(new double[]{4.0, 20.0, 2.0}, criteria);
        Alternative metro2 = new Alternative(new double[]{2.0, 20.0, 0.0}, criteria);
        Alternative bus = new Alternative(new double[]{6.0, 40.0, 0.0}, criteria);
        Alternative taxi = new Alternative(new double[]{30.0, 30.0, 3.0}, criteria);
        Ranking<Alternative> ranking = new Ranking<Alternative>(new double[]{1.0, 2.0, 2.0, 3.0, 4.0}, rer, metro1, metro2, bus, taxi);
        LinearFunction[] actuals = starSolver.solve(ranking, criteria, Arrays.asList(rer, metro1, metro2, bus, taxi));
        double[][] expecteds = new double[][]{{0.0, 0.333, 0.333}, {0.0, 0.0, 0.333, 0.666}, {0.0, 0.0, 0.0, 0.0}};
        int i = 0;
        while (i < expecteds.length) {
            AssertHelper.assertArraysEqual(expecteds[i], actuals[i].getValues());
            ++i;
        }
    }

    @Test
    public void testSolve04() {
        UtaStarSolver starSolver = new UtaStarSolver(true);
        Criterion g1 = new Criterion(1, true);
        Criterion g2 = new Criterion(2, true);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(g1);
        criteria.add(g2);
        Alternative a1 = new Alternative(new double[]{4.0, 6.0}, criteria);
        Alternative a2 = new Alternative(new double[]{5.0, 5.0}, criteria);
        Alternative a3 = new Alternative(new double[]{6.0, 4.0}, criteria);
        Ranking<Alternative> ranking = new Ranking<Alternative>(new double[]{1.0, 2.0, 3.0}, a1, a3, a2);
        LinearFunction[] actuals = starSolver.solve(ranking, criteria, Arrays.asList(a1, a3, a2));
        double[][] expecteds = new double[][]{{0.0, 0.25}, {0.0, 0.0, 0.75}};
        int i = 0;
        while (i < expecteds.length) {
            AssertHelper.assertArraysEqual(expecteds[i], actuals[i].getValues());
            ++i;
        }
    }

    @Test
    public void testSolve05() {
        UtaStarSolver starSolver = new UtaStarSolver(true);
        Criterion g1 = new Criterion("a", 1, true);
        Criterion g2 = new Criterion("b", 1, true);
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(g1);
        criteria.add(g2);
        Alternative a1 = new Alternative(new double[]{4.0, 6.0}, criteria);
        Alternative a2 = new Alternative(new double[]{5.0, 5.0}, criteria);
        Alternative a3 = new Alternative(new double[]{6.0, 4.0}, criteria);
        Ranking<Alternative> ranking = new Ranking<Alternative>(new double[]{1.0, 2.0, 3.0}, a1, a3, a2);
        List<Alternative> asList = Arrays.asList(a1, a3, a2);
        LinearFunction[] actuals = starSolver.solve(ranking, criteria, asList);
        double[][] expecteds = new double[][]{{0.0, 0.25}, {0.0, 0.75}};
        int i = 0;
        while (i < expecteds.length) {
            AssertHelper.assertArraysEqual(expecteds[i], actuals[i].getValues());
            ++i;
        }
    }
}

