/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.Collections;
import java.util.List;
import utafx.Alternative;
import utafx.Ranking;

public class KendallHelper {
    public double getCoefficient(Ranking<Alternative> rankRef, Ranking<Alternative> rankFromUtil) {
        List<Alternative> alternatives = rankRef.getAlternatives();
        List<Alternative> alternativesFromUtil = rankFromUtil.getAlternatives();
        Collections.sort(alternatives);
        Collections.sort(alternativesFromUtil);
        int matrixSize = alternatives.size();
        double[][] matrix1 = new double[matrixSize][matrixSize];
        this.populateMatrix(rankRef, alternatives, matrix1);
        double[][] matrix2 = new double[matrixSize][matrixSize];
        this.populateMatrix(rankFromUtil, alternativesFromUtil, matrix2);
        double sum = 0.0;
        int i = 0;
        while (i < matrix2.length) {
            int j = 0;
            while (j < matrix2.length) {
                sum += Math.abs(matrix1[i][j] - matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        double result = 1.0 - 4.0 * (0.5 * sum / (double)(matrixSize * (matrixSize - 1)));
        return result;
    }

    private void populateMatrix(Ranking<Alternative> rank, List<Alternative> alternatives, double[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix.length) {
                matrix[i][j] = i == j || rank.getRank(alternatives.get(j)) > rank.getRank(alternatives.get(i)) ? 0.0 : (rank.getRank(alternatives.get(j)) == rank.getRank(alternatives.get(i)) ? 0.5 : 1.0);
                ++j;
            }
            ++i;
        }
    }
}

