/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import utafx.Criterion;
import utafx.Point;

public class LinearFunction {
    private final Criterion criterion;
    private final List<Point> characteristicPoints = new ArrayList<Point>();

    public LinearFunction(Criterion criterion) {
        this.criterion = criterion;
        double interval = (criterion.getBestValue() - criterion.getWorstValue()) / (double)criterion.getNoOfSegments();
        this.characteristicPoints.add(new Point(criterion.getWorstValue(), 0.0));
        int i = 1;
        while (i < criterion.getNoOfSegments() + 1) {
            this.characteristicPoints.add(new Point(this.characteristicPoints.get(i - 1).getX() + interval, 0.0));
            ++i;
        }
    }

    public LinearFunction(double[] characteristicPoints, double[] values, Criterion criterion) {
        int i = 0;
        while (i < characteristicPoints.length) {
            this.characteristicPoints.add(new Point(characteristicPoints[i], values[i]));
            ++i;
        }
        this.criterion = criterion;
    }

    public LinearFunction(LinearFunction toCopy) {
        this.criterion = new Criterion(toCopy.criterion.getName(), toCopy.criterion.isGain(), toCopy.criterion.getNoOfSegments());
        for (Point p : toCopy.characteristicPoints) {
            this.characteristicPoints.add(new Point(p.getX(), p.getY()));
        }
    }

    public Double[] getValues() {
        Double[] result = new Double[this.characteristicPoints.size()];
        int i = 0;
        Iterator<Point> iterator = this.characteristicPoints.iterator();
        while (iterator.hasNext()) {
            result[i] = iterator.next().getY();
            ++i;
        }
        return result;
    }

    public void addValue(double val, int index) {
        this.characteristicPoints.get(index).setY(val);
    }

    public List<Point> getPoints() {
        return Collections.unmodifiableList(this.characteristicPoints);
    }

    public Double[] getCharacteristicPoints() {
        Double[] result = new Double[this.characteristicPoints.size()];
        int i = 0;
        Iterator<Point> iterator = this.characteristicPoints.iterator();
        while (iterator.hasNext()) {
            result[i] = iterator.next().getX();
            ++i;
        }
        return result;
    }

    public int getNoOfPoints() {
        return this.characteristicPoints.size();
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public boolean isIncreasing() {
        return this.characteristicPoints.get(this.characteristicPoints.size() - 1).getX() - this.characteristicPoints.get(0).getX() > 0.0;
    }

    public double getValueAt(double point) {
        int i;
        Double temp = null;
        int index = -1;
        if (this.isIncreasing()) {
            if (this.characteristicPoints.get(0).getX() > point) {
                return this.characteristicPoints.get(0).getY();
            }
            i = 0;
            while (i < this.characteristicPoints.size()) {
                if (this.characteristicPoints.get(i).getX() > point) {
                    temp = this.characteristicPoints.get(i).getX();
                    index = i;
                    break;
                }
                ++i;
            }
        } else {
            if (this.characteristicPoints.get(0).getX() < point) {
                return this.characteristicPoints.get(0).getY();
            }
            i = 0;
            while (i < this.characteristicPoints.size()) {
                if (this.characteristicPoints.get(i).getX() < point) {
                    temp = this.characteristicPoints.get(i).getX();
                    index = i;
                    break;
                }
                ++i;
            }
        }
        i = index;
        if (temp == null) {
            return this.characteristicPoints.get(this.characteristicPoints.size() - 1).getY();
        }
        double interval = Math.abs(this.characteristicPoints.get(i).getX() - this.characteristicPoints.get(i - 1).getX());
        double distance = Math.abs(point - this.characteristicPoints.get(i - 1).getX());
        double val = this.characteristicPoints.get(i).getY() - this.characteristicPoints.get(i - 1).getY();
        double temp2 = val / interval;
        return distance * temp2 + this.characteristicPoints.get(i - 1).getY();
    }

    public Point getBetterNeighbor(Point p) {
        int index = this.characteristicPoints.indexOf(p);
        if (index == -1) {
            throw new RuntimeException("Tried to get a neighbor of a point which doesn't belong to this function!");
        }
        if (++index > this.characteristicPoints.size() - 1) {
            return null;
        }
        return this.characteristicPoints.get(index);
    }

    public Point getWorseNeighbor(Point p) {
        int index = this.characteristicPoints.indexOf(p);
        if (index == -1) {
            throw new RuntimeException("Tried to get a neighbor of a point which doesn't belong to this function!");
        }
        if (--index < 0) {
            return null;
        }
        return this.characteristicPoints.get(index);
    }

    public Point getBestPoint() {
        return this.characteristicPoints.get(this.characteristicPoints.size() - 1);
    }

    public void setPointAt(double x, Point point) {
        int i = 0;
        while (i < this.characteristicPoints.size()) {
            if (this.characteristicPoints.get(i).getX() == point.getX()) {
                this.characteristicPoints.set(i, point);
                return;
            }
            ++i;
        }
    }

    public boolean containsPoint(Point p) {
        return this.characteristicPoints.contains(p);
    }
}

