/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import org.junit.Assert;
import org.junit.Test;
import utafx.Criterion;
import utafx.LinearFunction;
import utafx.Point;

public class LinearFunctionTest {
    private static final double DELTA = 1.0E-7;

    @Test
    public void testGetValue_testOnCharacteristicPoints() {
        LinearFunction tested = new LinearFunction(new double[]{5.0, 9.0, 21.0}, new double[]{0.0, 0.4, 0.6}, null);
        junit.framework.Assert.assertEquals((Object)0.0, (Object)tested.getValueAt(5.0));
        junit.framework.Assert.assertEquals((Object)0.4, (Object)tested.getValueAt(9.0));
        junit.framework.Assert.assertEquals((Object)0.6, (Object)tested.getValueAt(21.0));
    }

    @Test
    public void testGetValue_testBetweenCharacteristicPoints() {
        LinearFunction tested = new LinearFunction(new double[]{5.0, 9.0, 21.0}, new double[]{0.0, 0.4, 0.6}, null);
        junit.framework.Assert.assertEquals((Object)0.0, (Object)tested.getValueAt(4.0));
        junit.framework.Assert.assertEquals((Object)0.0, (Object)tested.getValueAt(5.0));
        junit.framework.Assert.assertEquals((double)0.3, (double)tested.getValueAt(8.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.2, (double)tested.getValueAt(7.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.6, (double)tested.getValueAt(21.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.6, (double)tested.getValueAt(22.0), (double)1.0E-7);
    }

    @Test
    public void testGetValue_testBetweenCharacteristicPoints_Decreasing() {
        LinearFunction tested = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.4, 0.6}, null);
        junit.framework.Assert.assertEquals((double)0.0, (double)tested.getValueAt(22.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.0, (double)tested.getValueAt(21.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.2, (double)tested.getValueAt(15.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.5, (double)tested.getValueAt(7.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.55, (double)tested.getValueAt(6.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.6, (double)tested.getValueAt(5.0), (double)1.0E-7);
        junit.framework.Assert.assertEquals((double)0.6, (double)tested.getValueAt(4.5), (double)1.0E-7);
    }

    @Test
    public void testIsIncreasing1() {
        LinearFunction tested = new LinearFunction(new double[]{21.0, 9.0, 5.0}, new double[]{0.0, 0.4, 0.6}, null);
        junit.framework.Assert.assertFalse((boolean)tested.isIncreasing());
    }

    @Test
    public void testIsIncreasing2() {
        LinearFunction tested = new LinearFunction(new double[]{9.0, 9.0, 15.0}, new double[]{0.0, 0.4, 0.6}, null);
        junit.framework.Assert.assertTrue((boolean)tested.isIncreasing());
    }

    @Test
    public void testGetBetterNeighbor() {
        LinearFunction tested = new LinearFunction(new double[]{9.0, 9.0, 15.0}, new double[]{0.0, 0.4, 0.6}, null);
        Assert.assertNull((Object)tested.getBetterNeighbor(tested.getPoints().get(2)));
    }

    @Test
    public void testGetBetterNeighbor02() {
        LinearFunction tested = new LinearFunction(new double[]{9.0, 9.0, 15.0}, new double[]{0.0, 0.4, 0.6}, null);
        Assert.assertNotNull((Object)tested.getBetterNeighbor(tested.getPoints().get(1)));
        Assert.assertEquals((Object)tested.getPoints().get(2), (Object)tested.getBetterNeighbor(tested.getPoints().get(1)));
    }

    @Test
    public void testGetWorseNeighbor() {
        LinearFunction tested = new LinearFunction(new double[]{15.0, 9.0, 4.0}, new double[]{0.6, 0.4, 0.3}, null);
        Assert.assertNull((Object)tested.getWorseNeighbor(tested.getPoints().get(0)));
    }

    @Test
    public void testGetWorseNeighbor02() {
        LinearFunction tested = new LinearFunction(new double[]{15.0, 14.0, 11.0}, new double[]{0.6, 0.4, 0.3}, null);
        Point worseNeighbor = tested.getWorseNeighbor(tested.getPoints().get(1));
        Assert.assertNotNull((Object)worseNeighbor);
        Assert.assertEquals((Object)tested.getPoints().get(0), (Object)worseNeighbor);
    }

    @Test
    public void testCopyingConstructor() {
        LinearFunction f = new LinearFunction(new double[]{15.0, 14.0, 11.0}, new double[]{0.6, 0.4, 0.3}, new Criterion(1, false));
        LinearFunction copyOfF = new LinearFunction(f);
        Assert.assertFalse((f.getCriterion() == copyOfF.getCriterion() ? 1 : 0) != 0);
        Assert.assertEquals((Object)f.getCriterion(), (Object)copyOfF.getCriterion());
        Assert.assertFalse((f.getPoints() == copyOfF.getPoints() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)f.getPoints().equals(copyOfF.getPoints()));
    }
}

