/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import junit.framework.Assert;
import org.junit.Test;
import utafx.Alternative;
import utafx.Ranking;

public class RankingTest {
    @Test
    public void testGetSuccessor() {
        double[] ranking = new double[]{1.0, 2.0, 3.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a2, a3);
        Assert.assertEquals((Object)a2, (Object)tested.getSuccessor(a1));
        Assert.assertEquals((Object)a3, (Object)tested.getSuccessor(a2));
    }

    @Test
    public void testGetSuccessor2() {
        double[] ranking = new double[]{1.0, 3.0, 2.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a2, a3);
        Assert.assertEquals((Object)a3, (Object)tested.getSuccessor(a1));
        Assert.assertEquals((Object)a2, (Object)tested.getSuccessor(a3));
        Assert.assertEquals(null, (Object)tested.getSuccessor(a2));
    }

    @Test
    public void testGetSuccessor3() {
        double[] ranking = new double[]{1.0, 2.0, 2.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a3, a2);
        Assert.assertEquals((Object)a3, (Object)tested.getSuccessor(a1));
        Assert.assertEquals((Object)a2, (Object)tested.getSuccessor(a3));
        Assert.assertEquals(null, (Object)tested.getSuccessor(a2));
    }

    @Test
    public void testGetRank() {
        double[] ranking = new double[]{1.0, 2.0, 2.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a3, a2);
        Assert.assertEquals((Object)2.0, (Object)tested.getRank(a3));
        Assert.assertEquals((Object)2.0, (Object)tested.getRank(a2));
        Assert.assertEquals((Object)1.0, (Object)tested.getRank(a1));
    }

    @Test
    public void testSameRank() {
        double[] ranking = new double[]{1.0, 2.0, 2.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a3, a2);
        Assert.assertTrue((boolean)tested.sameRank(a2, a3));
        Assert.assertTrue((boolean)tested.sameRank(a3, a2));
        Assert.assertFalse((boolean)tested.sameRank(a1, a2));
        Assert.assertFalse((boolean)tested.sameRank(a1, a3));
    }

    @Test
    public void testGetNumberOfRanks1() {
        double[] ranking = new double[]{1.0, 2.0, 2.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a3, a2);
        Assert.assertEquals((int)2, (int)tested.getNumberOfRanks());
    }

    @Test
    public void testGetNumberOfRanks2() {
        double[] ranking = new double[]{3.0, 2.0, 2.0, 1.0, 1.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Alternative a4 = new Alternative();
        Alternative a5 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a3, a2, a4, a5);
        Assert.assertEquals((int)3, (int)tested.getNumberOfRanks());
    }

    @Test
    public void testGetNumberOfRanks3() {
        double[] ranking = new double[]{5.0, 1.0, 2.0};
        Alternative a1 = new Alternative();
        Alternative a2 = new Alternative();
        Alternative a3 = new Alternative();
        Ranking<Alternative> tested = new Ranking<Alternative>(ranking, a1, a3, a2);
        Assert.assertEquals((int)3, (int)tested.getNumberOfRanks());
    }
}

